/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.bytes;

import java.io.EOFException;
import java.io.IOException;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.tokens.Encoding;

public final class OutputStream
implements IOutputStream {
    private java.io.OutputStream stream;
    private int length;

    public OutputStream(java.io.OutputStream stream) {
        this.stream = stream;
    }

    @Override
    public void write(byte[] data) {
        try {
            this.stream.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.length += data.length;
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        try {
            this.stream.write(data, offset, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.length += length;
    }

    @Override
    public void write(String data) {
        try {
            this.stream.write(Encoding.Pdf.encode(data));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.length += data.length();
    }

    @Override
    public void write(IInputStream data) {
        try {
            byte[] baseData = new byte[(int)data.getLength()];
            data.seek(0L);
            data.read(baseData);
            this.write(baseData);
        }
        catch (EOFException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

