/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.bytes.filters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.filters.Filter;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;

@PDF(value=VersionEnum.PDF12)
public final class FlateFilter
extends Filter {
    FlateFilter() {
    }

    @Override
    public byte[] decode(byte[] data, int offset, int length, PdfDictionary parameters) {
        try {
            InflaterInputStream inputFilter = new InflaterInputStream(new ByteArrayInputStream(data, offset, length));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.transform(inputFilter, outputStream);
            return this.decodePredictor(outputStream.toByteArray(), parameters);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] encode(byte[] data, int offset, int length, PdfDictionary parameters) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data, offset, length);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DeflaterOutputStream outputFilter = new DeflaterOutputStream(outputStream);
            this.transform(inputStream, outputFilter);
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] decodePredictor(byte[] data, PdfDictionary parameters) throws IOException {
        int predictor;
        if (parameters == null) {
            return data;
        }
        int n = predictor = parameters.containsKey(PdfName.Predictor) ? (Integer)((PdfInteger)parameters.get(PdfName.Predictor)).getRawValue() : 1;
        if (predictor == 1) {
            return data;
        }
        int sampleComponentBitsCount = parameters.containsKey(PdfName.BitsPerComponent) ? (Integer)((PdfInteger)parameters.get(PdfName.BitsPerComponent)).getRawValue() : 8;
        int sampleComponentsCount = parameters.containsKey(PdfName.Colors) ? (Integer)((PdfInteger)parameters.get(PdfName.Colors)).getRawValue() : 1;
        int rowSamplesCount = parameters.containsKey(PdfName.Columns) ? (Integer)((PdfInteger)parameters.get(PdfName.Columns)).getRawValue() : 1;
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        switch (predictor) {
            case 2: {
                int[] sampleComponentPredictions = new int[sampleComponentsCount];
                int sampleComponentDelta = 0;
                int sampleComponentIndex = 0;
                while ((sampleComponentDelta = ((InputStream)input).read()) != -1) {
                    int sampleComponent = sampleComponentDelta + sampleComponentPredictions[sampleComponentIndex];
                    output.write(sampleComponent);
                    sampleComponentPredictions[sampleComponentIndex] = sampleComponent;
                    ++sampleComponentIndex;
                    sampleComponentIndex %= sampleComponentsCount;
                }
                break;
            }
            default: {
                int predictionMethod;
                int sampleBytesCount = (int)Math.ceil(sampleComponentBitsCount * sampleComponentsCount / 8);
                int rowSampleBytesCount = (int)Math.ceil(sampleComponentBitsCount * sampleComponentsCount * rowSamplesCount / 8) + sampleBytesCount;
                int[] previousRowBytePredictions = new int[rowSampleBytesCount];
                int[] currentRowBytePredictions = new int[rowSampleBytesCount];
                int[] leftBytePredictions = new int[sampleBytesCount];
                while ((predictionMethod = ((InputStream)input).read()) != -1) {
                    System.arraycopy(currentRowBytePredictions, 0, previousRowBytePredictions, 0, currentRowBytePredictions.length);
                    Arrays.fill(leftBytePredictions, 0, leftBytePredictions.length, 0);
                    int rowSampleByteIndex = sampleBytesCount;
                    while (rowSampleByteIndex < rowSampleBytesCount) {
                        int sampleByte;
                        int byteDelta = ((InputStream)input).read();
                        int sampleByteIndex = rowSampleByteIndex % sampleBytesCount;
                        switch (predictionMethod) {
                            case 0: {
                                sampleByte = byteDelta;
                                break;
                            }
                            case 1: {
                                sampleByte = byteDelta + leftBytePredictions[sampleByteIndex];
                                break;
                            }
                            case 2: {
                                sampleByte = byteDelta + previousRowBytePredictions[rowSampleByteIndex];
                                break;
                            }
                            case 3: {
                                sampleByte = byteDelta + (int)Math.floor((leftBytePredictions[sampleByteIndex] + previousRowBytePredictions[rowSampleByteIndex]) / 2);
                                break;
                            }
                            case 4: {
                                int leftBytePrediction = leftBytePredictions[sampleByteIndex];
                                int topBytePrediction = previousRowBytePredictions[rowSampleByteIndex];
                                int topLeftBytePrediction = previousRowBytePredictions[rowSampleByteIndex - sampleBytesCount];
                                int initialPrediction = leftBytePrediction + topBytePrediction - topLeftBytePrediction;
                                int leftPrediction = Math.abs(initialPrediction - leftBytePrediction);
                                int topPrediction = Math.abs(initialPrediction - topBytePrediction);
                                int topLeftPrediction = Math.abs(initialPrediction - topLeftBytePrediction);
                                int paethPrediction = leftPrediction <= topPrediction && leftPrediction <= topLeftPrediction ? leftBytePrediction : (topPrediction <= topLeftPrediction ? topBytePrediction : topLeftBytePrediction);
                                sampleByte = byteDelta + paethPrediction;
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Prediction method " + predictionMethod + " unknown.");
                            }
                        }
                        output.write(sampleByte);
                        leftBytePredictions[sampleByteIndex] = currentRowBytePredictions[rowSampleByteIndex] = sampleByte;
                        ++rowSampleByteIndex;
                    }
                }
                break block0;
            }
        }
        return output.toByteArray();
    }

    private void transform(InputStream input, OutputStream output) throws IOException {
        int bufferLength;
        byte[] buffer = new byte[8192];
        while ((bufferLength = input.read(buffer, 0, buffer.length)) != -1) {
            output.write(buffer, 0, bufferLength);
        }
        input.close();
        output.close();
    }
}

