/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.pdfclown.PDF;
import org.pdfclown.Version;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Articles;
import org.pdfclown.documents.DocumentActions;
import org.pdfclown.documents.Names;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.PageFormat;
import org.pdfclown.documents.PageLabels;
import org.pdfclown.documents.Pages;
import org.pdfclown.documents.contents.Resources;
import org.pdfclown.documents.contents.layers.LayerDefinition;
import org.pdfclown.documents.interaction.forms.Form;
import org.pdfclown.documents.interaction.navigation.document.Bookmarks;
import org.pdfclown.documents.interaction.navigation.document.Destination;
import org.pdfclown.documents.interaction.viewer.ViewerPreferences;
import org.pdfclown.documents.interchange.metadata.Information;
import org.pdfclown.files.File;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfString;
import org.pdfclown.objects.Rectangle;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF10)
public final class Document
extends PdfObjectWrapper<PdfDictionary>
implements Pageable {
    public Hashtable<PdfReference, Object> cache = new Hashtable();
    private Configuration configuration = new Configuration(this);

    public static <T extends PdfObjectWrapper<?>> T resolve(Class<T> type, PdfDirectObject baseObject) {
        if (Destination.class.isAssignableFrom(type)) {
            return (T)Destination.wrap(baseObject);
        }
        throw new UnsupportedOperationException("Type '" + type.getName() + "' wrapping is not supported.");
    }

    public Document(File context) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.Catalog}));
        context.getTrailer().put(PdfName.Root, this.getBaseObject());
        this.setPages(new Pages(this));
        this.setPageSize(PageFormat.getSize());
        this.setResources(new Resources(this));
    }

    public Document(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Document clone(Document context) {
        throw new NotImplementedException();
    }

    public void exclude(PdfObjectWrapper<?> object) {
        if (object.getFile() != this.getFile()) {
            return;
        }
        object.delete();
    }

    public void exclude(Collection<? extends PdfObjectWrapper<?>> objects) {
        for (PdfObjectWrapper<?> object : objects) {
            this.exclude(object);
        }
    }

    @PDF(value=VersionEnum.PDF14)
    public DocumentActions getActions() {
        return new DocumentActions(((PdfDictionary)this.getBaseDataObject()).get(PdfName.AA, PdfDictionary.class));
    }

    @PDF(value=VersionEnum.PDF11)
    public Articles getArticles() {
        return Articles.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Threads, PdfArray.class, false));
    }

    public Bookmarks getBookmarks() {
        return Bookmarks.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Outlines, PdfDictionary.class, false));
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @PDF(value=VersionEnum.PDF12)
    public Form getForm() {
        return Form.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.AcroForm, PdfDictionary.class));
    }

    public Information getInformation() {
        return Information.wrap(this.getFile().getTrailer().get(PdfName.Info, PdfDictionary.class, false));
    }

    @PDF(value=VersionEnum.PDF15)
    public LayerDefinition getLayer() {
        return LayerDefinition.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.OCProperties, PdfDictionary.class));
    }

    @PDF(value=VersionEnum.PDF12)
    public Names getNames() {
        return new Names(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Names, PdfDictionary.class));
    }

    @PDF(value=VersionEnum.PDF13)
    public PageLabels getPageLabels() {
        return new PageLabels(((PdfDictionary)this.getBaseDataObject()).get(PdfName.PageLabels, PdfDictionary.class));
    }

    public PageLayoutEnum getPageLayout() {
        return PageLayoutEnum.valueOf((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.PageLayout));
    }

    public PageModeEnum getPageMode() {
        return PageModeEnum.valueOf((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.PageMode));
    }

    public Pages getPages() {
        return new Pages(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Pages));
    }

    public Dimension2D getPageSize() {
        PdfArray mediaBox = this.getMediaBox();
        return mediaBox != null ? new Dimension(((PdfNumber)mediaBox.get(2)).getValue().intValue(), ((PdfNumber)mediaBox.get(3)).getValue().intValue()) : null;
    }

    public Resources getResources() {
        return Resources.wrap(((PdfDictionary)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Pages)).get(PdfName.Resources, PdfDictionary.class));
    }

    public Dimension2D getSize() {
        double height = 0.0;
        double width = 0.0;
        for (Page page : this.getPages()) {
            Dimension2D pageSize = page.getSize();
            height = Math.max(height, pageSize.getHeight());
            width = Math.max(width, pageSize.getWidth());
        }
        return new org.pdfclown.util.math.geom.Dimension(width, height);
    }

    @PDF(value=VersionEnum.PDF14)
    public Version getVersion() {
        Version fileVersion = this.getFile().getVersion();
        PdfName versionObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Version);
        if (versionObject == null) {
            return fileVersion;
        }
        Version version = Version.get(versionObject);
        if (this.getFile().getReader() == null) {
            return version;
        }
        return version.compareTo(fileVersion) > 0 ? version : fileVersion;
    }

    @PDF(value=VersionEnum.PDF12)
    public ViewerPreferences getViewerPreferences() {
        return ViewerPreferences.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.ViewerPreferences, PdfDictionary.class));
    }

    public PdfObjectWrapper<?> include(PdfObjectWrapper<?> object) {
        if (object.getFile() == this.getFile()) {
            return object;
        }
        return (PdfObjectWrapper)object.clone(this);
    }

    public Collection<? extends PdfObjectWrapper<?>> include(Collection<? extends PdfObjectWrapper<?>> objects) {
        ArrayList includedObjects = new ArrayList(objects.size());
        for (PdfObjectWrapper<?> object : objects) {
            includedObjects.add(this.include(object));
        }
        return includedObjects;
    }

    public <T extends PdfObjectWrapper<?>> T resolveName(Class<T> type, PdfDirectObject namedBaseObject) {
        if (namedBaseObject instanceof PdfString) {
            return this.getNames().get(type, (PdfString)namedBaseObject);
        }
        return Document.resolve(type, namedBaseObject);
    }

    public void setActions(DocumentActions value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AA, PdfObjectWrapper.getBaseObject(value));
    }

    public void setArticles(Articles value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Threads, PdfObjectWrapper.getBaseObject(value));
    }

    public void setBookmarks(Bookmarks value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Outlines, PdfObjectWrapper.getBaseObject(value));
    }

    public void setConfiguration(Configuration value) {
        this.configuration = value;
    }

    public void setForm(Form value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AcroForm, PdfObjectWrapper.getBaseObject(value));
    }

    public void setInformation(Information value) {
        this.getFile().getTrailer().put(PdfName.Info, PdfObjectWrapper.getBaseObject(value));
    }

    public void setLayer(LayerDefinition value) {
        this.checkCompatibility("layer");
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.OCProperties, PdfObjectWrapper.getBaseObject(value));
    }

    public void setNames(Names value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Names, PdfObjectWrapper.getBaseObject(value));
    }

    public void setPageLabels(PageLabels value) {
        this.checkCompatibility("pageLabels");
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PageLabels, PdfObjectWrapper.getBaseObject(value));
    }

    public void setPageLayout(PageLayoutEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PageLayout, value.getName());
    }

    public void setPageMode(PageModeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PageMode, value.getName());
    }

    public void setPages(Pages value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Pages, PdfObjectWrapper.getBaseObject(value));
    }

    public void setPageSize(Dimension2D value) {
        PdfArray mediaBox = this.getMediaBox();
        if (mediaBox == null) {
            mediaBox = (PdfArray)new Rectangle(0.0, 0.0, 0.0, 0.0).getBaseDataObject();
            ((PdfDictionary)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Pages)).put(PdfName.MediaBox, mediaBox);
        }
        mediaBox.set(2, PdfReal.get(value.getWidth()));
        mediaBox.set(3, PdfReal.get(value.getHeight()));
    }

    public void setResources(Resources value) {
        ((PdfDictionary)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Pages)).put(PdfName.Resources, PdfObjectWrapper.getBaseObject(value));
    }

    public void setVersion(Version value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Version, PdfName.get(value));
    }

    public void setViewerPreferences(ViewerPreferences value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.ViewerPreferences, PdfObjectWrapper.getBaseObject(value));
    }

    @Override
    public int getNumberOfPages() {
        return this.getPages().size();
    }

    @Override
    public java.awt.print.PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        java.awt.print.PageFormat pageFormat = new java.awt.print.PageFormat();
        Page page = this.getPages().get(pageIndex);
        Paper paper = new Paper();
        Rectangle2D pageBox = page.getBox();
        paper.setSize(pageBox.getWidth(), pageBox.getHeight());
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this.getPages().get(pageIndex);
    }

    private PdfArray getMediaBox() {
        return (PdfArray)((PdfDictionary)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Pages)).resolve(PdfName.MediaBox);
    }

    public static final class Configuration {
        private CompatibilityModeEnum compatibilityMode = CompatibilityModeEnum.Loose;
        private XRefModeEnum xrefMode = XRefModeEnum.Plain;
        private final Document document;

        Configuration(Document document) {
            this.document = document;
        }

        public CompatibilityModeEnum getCompatibilityMode() {
            return this.compatibilityMode;
        }

        public Document getDocument() {
            return this.document;
        }

        public XRefModeEnum getXrefMode() {
            return this.xrefMode;
        }

        public void setCompatibilityMode(CompatibilityModeEnum value) {
            this.compatibilityMode = value;
        }

        public void setXrefMode(XRefModeEnum value) {
            this.xrefMode = value;
            this.document.checkCompatibility((Object)this.xrefMode);
        }

        public static enum CompatibilityModeEnum {
            Passthrough,
            Loose,
            Strict;

        }

        public static enum XRefModeEnum {
            Plain,
            Compressed;

        }
    }

    public static enum PageLayoutEnum {
        SinglePage(PdfName.SinglePage),
        OneColumn(PdfName.OneColumn),
        TwoColumnLeft(PdfName.TwoColumnLeft),
        TwoColumnRight(PdfName.TwoColumnRight),
        TwoPageLeft(PdfName.TwoPageLeft),
        TwoPageRight(PdfName.TwoPageRight);

        private PdfName name;

        private PageLayoutEnum(PdfName name) {
            this.name = name;
        }

        public PdfName getName() {
            return this.name;
        }

        public static PageLayoutEnum valueOf(String string) {
            return Enum.valueOf(PageLayoutEnum.class, string);
        }
    }

    public static enum PageModeEnum {
        Simple(PdfName.UseNone),
        Bookmarks(PdfName.UseOutlines),
        Thumbnails(PdfName.UseThumbs),
        FullScreen(PdfName.FullScreen),
        Layers(PdfName.UseOC),
        Attachments(PdfName.UseAttachments);

        private PdfName name;

        private PageModeEnum(PdfName name) {
            this.name = name;
        }

        public PdfName getName() {
            return this.name;
        }

        public static PageModeEnum valueOf(String string) {
            return Enum.valueOf(PageModeEnum.class, string);
        }
    }
}

