/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.objects.PdfName;

@PDF(value=VersionEnum.PDF14)
public enum BlendModeEnum {
    Normal(PdfName.Normal),
    Multiply(PdfName.Multiply),
    Screen(PdfName.Screen),
    Overlay(PdfName.Overlay),
    Darken(PdfName.Darken),
    Lighten(PdfName.Lighten),
    ColorDodge(PdfName.ColorDodge),
    ColorBurn(PdfName.ColorBurn),
    HardLight(PdfName.HardLight),
    SoftLight(PdfName.SoftLight),
    Difference(PdfName.Difference),
    Exclusion(PdfName.Exclusion),
    Hue(PdfName.Hue),
    Saturation(PdfName.Saturation),
    Color(PdfName.Color),
    Luminosity(PdfName.Luminosity);

    private final PdfName code;

    public static BlendModeEnum get(PdfName value) {
        BlendModeEnum[] blendModeEnumArray = BlendModeEnum.values();
        int n = blendModeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlendModeEnum mode = blendModeEnumArray[n2];
            if (mode.getCode().equals(value)) {
                return mode;
            }
            ++n2;
        }
        return null;
    }

    private BlendModeEnum(PdfName code) {
        this.code = code;
    }

    public PdfName getCode() {
        return this.code;
    }
}

