/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.BlendModeEnum;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.LineCapEnum;
import org.pdfclown.documents.contents.LineDash;
import org.pdfclown.documents.contents.LineJoinEnum;
import org.pdfclown.documents.contents.fonts.Font;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfSimpleObject;

@PDF(value=VersionEnum.PDF12)
public final class ExtGState
extends PdfObjectWrapper<PdfDictionary> {
    public static ExtGState wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new ExtGState(baseObject) : null;
    }

    public ExtGState(Document context) {
        super(context, new PdfDictionary());
    }

    ExtGState(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public void applyTo(ContentScanner.GraphicsState state) {
        for (PdfName parameterName : ((PdfDictionary)this.getBaseDataObject()).keySet()) {
            if (parameterName.equals(PdfName.Font)) {
                state.setFont(this.getFont());
                state.setFontSize(this.getFontSize());
                continue;
            }
            if (parameterName.equals(PdfName.LC)) {
                state.setLineCap(this.getLineCap());
                continue;
            }
            if (parameterName.equals(PdfName.D)) {
                state.setLineDash(this.getLineDash());
                continue;
            }
            if (parameterName.equals(PdfName.LJ)) {
                state.setLineJoin(this.getLineJoin());
                continue;
            }
            if (parameterName.equals(PdfName.LW)) {
                state.setLineWidth(this.getLineWidth());
                continue;
            }
            if (parameterName.equals(PdfName.ML)) {
                state.setMiterLimit(this.getMiterLimit());
                continue;
            }
            if (!parameterName.equals(PdfName.BM)) continue;
            state.setBlendMode(this.getBlendMode());
        }
    }

    @Override
    public ExtGState clone(Document context) {
        return (ExtGState)super.clone(context);
    }

    @PDF(value=VersionEnum.PDF14)
    public List<BlendModeEnum> getBlendMode() {
        PdfDirectObject blendModeObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.BM);
        if (blendModeObject == null) {
            return Collections.emptyList();
        }
        ArrayList<BlendModeEnum> blendMode = new ArrayList<BlendModeEnum>();
        if (blendModeObject instanceof PdfName) {
            blendMode.add(BlendModeEnum.get((PdfName)blendModeObject));
        } else {
            for (PdfDirectObject alternateBlendModeObject : (PdfArray)blendModeObject) {
                blendMode.add(BlendModeEnum.get((PdfName)alternateBlendModeObject));
            }
        }
        return blendMode;
    }

    @PDF(value=VersionEnum.PDF14)
    public Double getFillAlpha() {
        return (Double)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.ca));
    }

    @PDF(value=VersionEnum.PDF13)
    public Font getFont() {
        PdfArray fontObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Font);
        return fontObject != null ? Font.wrap(fontObject.get(0)) : null;
    }

    @PDF(value=VersionEnum.PDF13)
    public Double getFontSize() {
        PdfArray fontObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Font);
        return fontObject != null ? Double.valueOf(((PdfNumber)fontObject.get(1)).getDoubleValue()) : null;
    }

    @PDF(value=VersionEnum.PDF13)
    public LineCapEnum getLineCap() {
        PdfInteger lineCapObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LC);
        return lineCapObject != null ? LineCapEnum.valueOf((Integer)lineCapObject.getRawValue()) : null;
    }

    @PDF(value=VersionEnum.PDF13)
    public LineDash getLineDash() {
        PdfArray lineDashObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.D);
        if (lineDashObject == null) {
            return null;
        }
        PdfArray baseDashArray = (PdfArray)lineDashObject.get(0);
        double[] dashArray = new double[baseDashArray.size()];
        int index = 0;
        int length = dashArray.length;
        while (index < length) {
            dashArray[index] = ((PdfNumber)baseDashArray.get(index)).getDoubleValue();
            ++index;
        }
        double dashPhase = ((PdfNumber)lineDashObject.get(1)).getDoubleValue();
        return new LineDash(dashArray, dashPhase);
    }

    @PDF(value=VersionEnum.PDF13)
    public LineJoinEnum getLineJoin() {
        PdfInteger lineJoinObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LJ);
        return lineJoinObject != null ? LineJoinEnum.valueOf((Integer)lineJoinObject.getRawValue()) : null;
    }

    @PDF(value=VersionEnum.PDF13)
    public Double getLineWidth() {
        PdfNumber lineWidthObject = (PdfNumber)((PdfDictionary)this.getBaseDataObject()).get(PdfName.LW);
        return lineWidthObject != null ? Double.valueOf(lineWidthObject.getDoubleValue()) : null;
    }

    @PDF(value=VersionEnum.PDF13)
    public Double getMiterLimit() {
        PdfNumber miterLimitObject = (PdfNumber)((PdfDictionary)this.getBaseDataObject()).get(PdfName.ML);
        return miterLimitObject != null ? Double.valueOf(miterLimitObject.getDoubleValue()) : null;
    }

    @PDF(value=VersionEnum.PDF14)
    public Double getStrokeAlpha() {
        return (Double)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.CA));
    }

    @PDF(value=VersionEnum.PDF14)
    public boolean isAlphaShape() {
        return (Boolean)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.AIS), false);
    }

    public void setAlphaShape(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.AIS, PdfBoolean.get(value));
    }

    public void setBlendMode(List<BlendModeEnum> value) {
        PdfDirectObject blendModeObject;
        if (value == null || value.isEmpty()) {
            blendModeObject = null;
        } else if (value.size() == 1) {
            blendModeObject = value.get(0).getCode();
        } else {
            PdfArray blendModeArray = new PdfArray();
            for (BlendModeEnum blendMode : value) {
                blendModeArray.add(blendMode.getCode());
            }
            blendModeObject = blendModeArray;
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.BM, blendModeObject);
    }

    public void setBlendMode(BlendModeEnum ... value) {
        this.setBlendMode(Arrays.asList(value));
    }

    public void setFillAlpha(Double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.ca, PdfReal.get(value));
    }

    public void setFont(Font value) {
        PdfArray fontObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Font);
        if (fontObject == null) {
            fontObject = new PdfArray(PdfObjectWrapper.getBaseObject(value), PdfInteger.Default);
        } else {
            fontObject.set(0, PdfObjectWrapper.getBaseObject(value));
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Font, fontObject);
    }

    public void setFontSize(Double value) {
        PdfArray fontObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Font);
        if (fontObject == null) {
            fontObject = new PdfArray(null, PdfReal.get(value));
        } else {
            fontObject.set(1, PdfReal.get(value));
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Font, fontObject);
    }

    public void setLineCap(LineCapEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.LC, value != null ? PdfInteger.get(value.getCode()) : null);
    }

    public void setLineDash(LineDash value) {
        PdfArray lineDashObject = new PdfArray();
        PdfArray dashArrayObject = new PdfArray();
        double[] dArray = value.getDashArray();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double dashArrayItem = dArray[n2];
            dashArrayObject.add(PdfReal.get(dashArrayItem));
            ++n2;
        }
        lineDashObject.add(dashArrayObject);
        lineDashObject.add(PdfReal.get(value.getDashPhase()));
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.D, lineDashObject);
    }

    public void setLineJoin(LineJoinEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.LJ, value != null ? PdfInteger.get(value.getCode()) : null);
    }

    public void setLineWidth(Double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.LW, PdfReal.get(value));
    }

    public void setMiterLimit(Double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.ML, PdfReal.get(value));
    }

    public void setStrokeAlpha(Double value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.CA, PdfReal.get(value));
    }
}

