/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.colorSpaces;

import java.awt.Paint;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.colorSpaces.Color;
import org.pdfclown.documents.contents.colorSpaces.DeviceCMYKColor;
import org.pdfclown.documents.contents.colorSpaces.DeviceColorSpace;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF11)
public final class DeviceCMYKColorSpace
extends DeviceColorSpace {
    public static final DeviceCMYKColorSpace Default = new DeviceCMYKColorSpace(PdfName.DeviceCMYK);

    public DeviceCMYKColorSpace(Document context) {
        super(context, PdfName.DeviceCMYK);
    }

    DeviceCMYKColorSpace(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public DeviceCMYKColorSpace clone(Document context) {
        throw new NotImplementedException();
    }

    public DeviceCMYKColor getColor(List<PdfDirectObject> components, IContentContext context) {
        return new DeviceCMYKColor(components);
    }

    @Override
    public int getComponentCount() {
        return 4;
    }

    public DeviceCMYKColor getDefaultColor() {
        return DeviceCMYKColor.Default;
    }

    @Override
    public Paint getPaint(Color<?> color) {
        DeviceCMYKColor spaceColor = (DeviceCMYKColor)color;
        float keyCorrection = (float)spaceColor.getK() / 2.5f;
        float r = 1.0f - (float)spaceColor.getC() + keyCorrection;
        if (r > 1.0f) {
            r = 1.0f;
        } else if (r < 0.0f) {
            r = 0.0f;
        }
        float g = 1.0f - (float)spaceColor.getM() + keyCorrection;
        if (g > 1.0f) {
            g = 1.0f;
        } else if (g < 0.0f) {
            g = 0.0f;
        }
        float b = 1.0f - (float)spaceColor.getY() + keyCorrection;
        if (b > 1.0f) {
            b = 1.0f;
        } else if (b < 0.0f) {
            b = 0.0f;
        }
        return new java.awt.Color(r, g, b);
    }
}

