/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.colorSpaces;

import java.awt.Paint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.colorSpaces.Color;
import org.pdfclown.documents.contents.colorSpaces.ColorSpace;
import org.pdfclown.documents.contents.colorSpaces.IndexedColor;
import org.pdfclown.documents.contents.colorSpaces.SpecialColorSpace;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.util.IDataWrapper;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF11)
public final class IndexedColorSpace
extends SpecialColorSpace<PdfArray> {
    private final Map<Integer, Color<?>> baseColors = new HashMap();
    private byte[] baseComponentValues;
    private ColorSpace<?> baseSpace;

    IndexedColorSpace(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Object clone(Document context) {
        throw new NotImplementedException();
    }

    public Color<?> getBaseColor(IndexedColor color) {
        int colorIndex = color.getIndex();
        Color<?> baseColor = this.baseColors.get(colorIndex);
        if (baseColor == null) {
            ColorSpace<?> baseSpace = this.getBaseSpace();
            ArrayList<PdfDirectObject> components = new ArrayList<PdfDirectObject>();
            int componentCount = baseSpace.getComponentCount();
            int componentValueIndex = colorIndex * componentCount;
            byte[] baseComponentValues = this.getBaseComponentValues();
            int componentIndex = 0;
            while (componentIndex < componentCount) {
                components.add(PdfReal.get((double)(baseComponentValues[componentValueIndex++] & 0xFF) / 255.0));
                ++componentIndex;
            }
            baseColor = baseSpace.getColor(components, null);
        }
        return baseColor;
    }

    public ColorSpace<?> getBaseSpace() {
        if (this.baseSpace == null) {
            this.baseSpace = ColorSpace.wrap(((PdfArray)this.getBaseDataObject()).get(1));
        }
        return this.baseSpace;
    }

    public IndexedColor getColor(List<PdfDirectObject> components, IContentContext context) {
        return new IndexedColor(components);
    }

    @Override
    public int getComponentCount() {
        return 1;
    }

    @Override
    public Color<?> getDefaultColor() {
        return IndexedColor.Default;
    }

    @Override
    public Paint getPaint(Color<?> color) {
        return this.getBaseSpace().getPaint(this.getBaseColor((IndexedColor)color));
    }

    private byte[] getBaseComponentValues() {
        if (this.baseComponentValues == null) {
            this.baseComponentValues = ((IDataWrapper)((Object)((PdfArray)this.getBaseDataObject()).resolve(3))).toByteArray();
        }
        return this.baseComponentValues;
    }
}

