/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.colorSpaces;

import java.awt.Paint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.colorSpaces.CIEBasedColorSpace;
import org.pdfclown.documents.contents.colorSpaces.Color;
import org.pdfclown.documents.contents.colorSpaces.LabColor;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.util.NotImplementedException;
import org.pdfclown.util.math.Interval;

@PDF(value=VersionEnum.PDF11)
public final class LabColorSpace
extends CIEBasedColorSpace {
    LabColorSpace(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public LabColorSpace clone(Document context) {
        throw new NotImplementedException();
    }

    public LabColor getColor(List<PdfDirectObject> components, IContentContext context) {
        return new LabColor(components);
    }

    @Override
    public int getComponentCount() {
        return 3;
    }

    public LabColor getDefaultColor() {
        List<Interval<Double>> ranges = this.getRanges();
        return new LabColor(ranges.get(0).getLow(), ranges.get(1).getLow(), ranges.get(2).getLow());
    }

    public List<Interval<Double>> getRanges() {
        ArrayList<Interval<Double>> ranges = new ArrayList<Interval<Double>>();
        ranges.add(new Interval<Double>(0.0, 100.0));
        PdfArray rangesObject = (PdfArray)this.getDictionary().get(PdfName.Range);
        if (rangesObject == null) {
            ranges.add(new Interval<Double>(-100.0, 100.0));
            ranges.add(new Interval<Double>(-100.0, 100.0));
        } else {
            Iterator<PdfDirectObject> rangesObjectIterator = rangesObject.iterator();
            while (rangesObjectIterator.hasNext()) {
                ranges.add(new Interval<Double>(((PdfNumber)rangesObjectIterator.next()).getDoubleValue(), ((PdfNumber)rangesObjectIterator.next()).getDoubleValue()));
            }
        }
        return ranges;
    }

    @Override
    public Paint getPaint(Color<?> color) {
        return new java.awt.Color(0, 0, 0);
    }
}

