/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.composition;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Map;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.ExtGState;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.LineCapEnum;
import org.pdfclown.documents.contents.LineDash;
import org.pdfclown.documents.contents.LineJoinEnum;
import org.pdfclown.documents.contents.PropertyList;
import org.pdfclown.documents.contents.ResourceItems;
import org.pdfclown.documents.contents.TextRenderModeEnum;
import org.pdfclown.documents.contents.colorSpaces.Color;
import org.pdfclown.documents.contents.colorSpaces.DeviceCMYKColorSpace;
import org.pdfclown.documents.contents.colorSpaces.DeviceGrayColorSpace;
import org.pdfclown.documents.contents.colorSpaces.DeviceRGBColorSpace;
import org.pdfclown.documents.contents.composition.XAlignmentEnum;
import org.pdfclown.documents.contents.composition.YAlignmentEnum;
import org.pdfclown.documents.contents.fonts.Font;
import org.pdfclown.documents.contents.layers.LayerEntity;
import org.pdfclown.documents.contents.objects.ApplyExtGState;
import org.pdfclown.documents.contents.objects.BeginMarkedContent;
import org.pdfclown.documents.contents.objects.BeginSubpath;
import org.pdfclown.documents.contents.objects.CloseSubpath;
import org.pdfclown.documents.contents.objects.CompositeObject;
import org.pdfclown.documents.contents.objects.ContentObject;
import org.pdfclown.documents.contents.objects.DrawCurve;
import org.pdfclown.documents.contents.objects.DrawLine;
import org.pdfclown.documents.contents.objects.DrawRectangle;
import org.pdfclown.documents.contents.objects.LocalGraphicsState;
import org.pdfclown.documents.contents.objects.MarkedContent;
import org.pdfclown.documents.contents.objects.ModifyCTM;
import org.pdfclown.documents.contents.objects.ModifyClipPath;
import org.pdfclown.documents.contents.objects.PaintPath;
import org.pdfclown.documents.contents.objects.PaintXObject;
import org.pdfclown.documents.contents.objects.SetCharSpace;
import org.pdfclown.documents.contents.objects.SetFillColor;
import org.pdfclown.documents.contents.objects.SetFillColorSpace;
import org.pdfclown.documents.contents.objects.SetFont;
import org.pdfclown.documents.contents.objects.SetLineCap;
import org.pdfclown.documents.contents.objects.SetLineDash;
import org.pdfclown.documents.contents.objects.SetLineJoin;
import org.pdfclown.documents.contents.objects.SetLineWidth;
import org.pdfclown.documents.contents.objects.SetMiterLimit;
import org.pdfclown.documents.contents.objects.SetStrokeColor;
import org.pdfclown.documents.contents.objects.SetStrokeColorSpace;
import org.pdfclown.documents.contents.objects.SetTextLead;
import org.pdfclown.documents.contents.objects.SetTextMatrix;
import org.pdfclown.documents.contents.objects.SetTextRenderMode;
import org.pdfclown.documents.contents.objects.SetTextRise;
import org.pdfclown.documents.contents.objects.SetTextScale;
import org.pdfclown.documents.contents.objects.SetWordSpace;
import org.pdfclown.documents.contents.objects.ShowSimpleText;
import org.pdfclown.documents.contents.objects.Text;
import org.pdfclown.documents.contents.objects.TranslateTextRelative;
import org.pdfclown.documents.contents.objects.TranslateTextToNextLine;
import org.pdfclown.documents.contents.xObjects.XObject;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.documents.interaction.annotations.Link;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.util.math.geom.Quad;

public final class PrimitiveComposer {
    private ContentScanner scanner;

    public PrimitiveComposer(ContentScanner scanner) {
        this.setScanner(scanner);
    }

    public PrimitiveComposer(IContentContext context) {
        this(new ContentScanner(context.getContents()));
    }

    public ContentObject add(ContentObject object) {
        this.scanner.insert(object);
        this.scanner.moveNext();
        return object;
    }

    public void applyMatrix(double a, double b, double c, double d, double e, double f) {
        this.add(new ModifyCTM(a, b, c, d, e, f));
    }

    public void applyState(PdfName name) {
        if (!this.scanner.getContentContext().getResources().getExtGStates().containsKey(name)) {
            throw new IllegalArgumentException("No state resource associated to the given argument (name:'name'; value:'" + name + "';)");
        }
        this.applyState_(name);
    }

    public void applyState(ExtGState state) {
        this.applyState_(this.getResourceName(state));
    }

    public CompositeObject begin(CompositeObject object) {
        this.scanner.insert(object);
        this.scanner = this.scanner.getChildLevel();
        return object;
    }

    public MarkedContent beginLayer(LayerEntity layer) {
        return this.beginLayer(this.getResourceName(layer.getMembership()));
    }

    public MarkedContent beginLayer(PdfName layerName) {
        return this.beginMarkedContent(PdfName.OC, layerName);
    }

    public LocalGraphicsState beginLocalState() {
        return (LocalGraphicsState)this.begin(new LocalGraphicsState());
    }

    public MarkedContent beginMarkedContent(PdfName tag) {
        return this.beginMarkedContent(tag, (PdfName)null);
    }

    public MarkedContent beginMarkedContent(PdfName tag, PropertyList propertyList) {
        return this.beginMarkedContent_(tag, this.getResourceName(propertyList));
    }

    public MarkedContent beginMarkedContent(PdfName tag, PdfName propertyListName) {
        if (propertyListName != null && !this.scanner.getContentContext().getResources().getPropertyLists().containsKey(propertyListName)) {
            throw new IllegalArgumentException("No property list resource associated to the given argument (name:'name'; value:'" + propertyListName + "';)");
        }
        return this.beginMarkedContent_(tag, propertyListName);
    }

    public void clip() {
        this.add(ModifyClipPath.NonZero);
        this.add(PaintPath.EndPathNoOp);
    }

    public void closePath() {
        this.add(CloseSubpath.Value);
    }

    public void drawArc(RectangularShape location, double startAngle, double endAngle) {
        this.drawArc(location, startAngle, endAngle, 0.0, 1.0);
    }

    public void drawArc(RectangularShape location, double startAngle, double endAngle, double branchWidth, double branchRatio) {
        this.drawArc(location, startAngle, endAngle, branchWidth, branchRatio, true);
    }

    public void drawCurve(Point2D endPoint, Point2D startControl, Point2D endControl) {
        double contextHeight = this.scanner.getContentContext().getBox().getHeight();
        this.add(new DrawCurve(endPoint.getX(), contextHeight - endPoint.getY(), startControl.getX(), contextHeight - startControl.getY(), endControl.getX(), contextHeight - endControl.getY()));
    }

    public void drawCurve(Point2D startPoint, Point2D endPoint, Point2D startControl, Point2D endControl) {
        this.startPath(startPoint);
        this.drawCurve(endPoint, startControl, endControl);
    }

    public void drawEllipse(RectangularShape location) {
        this.drawArc(location, 0.0, 360.0);
    }

    public void drawLine(Point2D endPoint) {
        this.add(new DrawLine(endPoint.getX(), this.scanner.getContentContext().getBox().getHeight() - endPoint.getY()));
    }

    public void drawLine(Point2D startPoint, Point2D endPoint) {
        this.startPath(startPoint);
        this.drawLine(endPoint);
    }

    public void drawPolygon(Point2D[] points) {
        this.drawPolyline(points);
        this.closePath();
    }

    public void drawPolyline(Point2D[] points) {
        this.startPath(points[0]);
        int index = 1;
        int length = points.length;
        while (index < length) {
            this.drawLine(points[index]);
            ++index;
        }
    }

    public void drawRectangle(RectangularShape location) {
        this.drawRectangle(location, 0.0);
    }

    public void drawRectangle(RectangularShape location, double radius) {
        if (radius == 0.0) {
            this.add(new DrawRectangle(location.getX(), this.scanner.getContentContext().getBox().getHeight() - location.getY() - location.getHeight(), location.getWidth(), location.getHeight()));
        } else {
            double endRadians = Math.PI * 2;
            double quadrantRadians = 1.5707963267948966;
            double radians = 0.0;
            while (radians < Math.PI * 2) {
                double radians2 = radians + 1.5707963267948966;
                int sin2 = (int)Math.sin(radians2);
                int cos2 = (int)Math.cos(radians2);
                double x1 = 0.0;
                double x2 = 0.0;
                double y1 = 0.0;
                double y2 = 0.0;
                double xArc = 0.0;
                double yArc = 0.0;
                if (cos2 == 0) {
                    if (sin2 == 1) {
                        x1 = x2 = location.getX() + location.getWidth();
                        y1 = location.getY() + location.getHeight() - radius;
                        y2 = location.getY() + radius;
                        xArc = -radius * 2.0;
                        yArc = -radius;
                        this.startPath(new Point2D.Double(x1, y1));
                    } else {
                        x1 = x2 = location.getX();
                        y1 = location.getY() + radius;
                        y2 = location.getY() + location.getHeight() - radius;
                        yArc = -radius;
                    }
                } else if (cos2 == 1) {
                    x1 = location.getX() + radius;
                    x2 = location.getX() + location.getWidth() - radius;
                    y1 = y2 = location.getY() + location.getHeight();
                    xArc = -radius;
                    yArc = -radius * 2.0;
                } else if (cos2 == -1) {
                    x1 = location.getX() + location.getWidth() - radius;
                    x2 = location.getX() + radius;
                    y1 = y2 = location.getY();
                    xArc = -radius;
                }
                this.drawLine(new Point2D.Double(x2, y2));
                this.drawArc(new Rectangle2D.Double(x2 + xArc, y2 + yArc, radius * 2.0, radius * 2.0), Math.toDegrees(radians), Math.toDegrees(radians2), 0.0, 1.0, false);
                radians = radians2;
            }
        }
    }

    public void drawSpiral(Point2D center, double startAngle, double endAngle, double branchWidth, double branchRatio) {
        this.drawArc(new Rectangle2D.Double(center.getX(), center.getY(), 1.0E-4, 1.0E-4), startAngle, endAngle, branchWidth, branchRatio);
    }

    public void end() {
        this.scanner = this.scanner.getParentLevel();
        this.scanner.moveNext();
    }

    public void fill() {
        this.add(PaintPath.Fill);
    }

    public void fillStroke() {
        this.add(PaintPath.FillStroke);
    }

    public void flush() {
        this.scanner.getContents().flush();
    }

    public ContentScanner getScanner() {
        return this.scanner;
    }

    public ContentScanner.GraphicsState getState() {
        return this.scanner.getState();
    }

    public void rotate(double angle) {
        double rad = angle * Math.PI / 180.0;
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        this.applyMatrix(cos, sin, -sin, cos, 0.0, 0.0);
    }

    public void rotate(double angle, Point2D origin) {
        this.translate(origin.getX(), this.scanner.getContentContext().getBox().getHeight() - origin.getY());
        this.rotate(angle);
        this.translate(0.0, -this.scanner.getContentContext().getBox().getHeight());
    }

    public void scale(double ratioX, double ratioY) {
        this.applyMatrix(ratioX, 0.0, 0.0, ratioY, 0.0, 0.0);
    }

    public void setCharSpace(double value) {
        this.add(new SetCharSpace(value));
    }

    public void setFillColor(Color<?> value) {
        if (!this.scanner.getState().getFillColorSpace().equals(value.getColorSpace())) {
            this.add(new SetFillColorSpace(this.getResourceName(value.getColorSpace())));
        }
        this.add(new SetFillColor(value));
    }

    public void setFont(PdfName name, double size) {
        if (!this.scanner.getContentContext().getResources().getFonts().containsKey(name)) {
            throw new IllegalArgumentException("No font resource associated to the given argument (name:'name'; value:'" + name + "';)");
        }
        this.setFont_(name, size);
    }

    public void setFont(Font value, double size) {
        this.setFont_(this.getResourceName(value), size);
    }

    public void setTextScale(double value) {
        this.add(new SetTextScale(value));
    }

    public void setTextLead(double value) {
        this.add(new SetTextLead(value));
    }

    public void setLineCap(LineCapEnum value) {
        this.add(new SetLineCap(value));
    }

    public void setLineDash(LineDash value) {
        this.add(new SetLineDash(value));
    }

    public void setLineJoin(LineJoinEnum value) {
        this.add(new SetLineJoin(value));
    }

    public void setLineWidth(double value) {
        this.add(new SetLineWidth(value));
    }

    public void setMatrix(double a, double b, double c, double d, double e, double f) {
        this.add(ModifyCTM.getResetCTM(this.scanner.getState()));
        this.add(new ModifyCTM(a, b, c, d, e, f));
    }

    public void setMiterLimit(double value) {
        this.add(new SetMiterLimit(value));
    }

    public void setScanner(ContentScanner value) {
        this.scanner = value;
    }

    public void setStrokeColor(Color<?> value) {
        if (!this.scanner.getState().getStrokeColorSpace().equals(value.getColorSpace())) {
            this.add(new SetStrokeColorSpace(this.getResourceName(value.getColorSpace())));
        }
        this.add(new SetStrokeColor(value));
    }

    public void setTextRenderMode(TextRenderModeEnum value) {
        this.add(new SetTextRenderMode(value));
    }

    public void setTextRise(double value) {
        this.add(new SetTextRise(value));
    }

    public void setWordSpace(double value) {
        this.add(new SetWordSpace(value));
    }

    public Quad showText(String value) {
        return this.showText(value, new Point2D.Double(0.0, 0.0));
    }

    public Link showText(String value, Action action) {
        return this.showText(value, new Point2D.Double(0.0, 0.0), action);
    }

    public Quad showText(String value, Point2D location) {
        return this.showText(value, location, XAlignmentEnum.Left, YAlignmentEnum.Top, 0.0);
    }

    public Link showText(String value, Point2D location, Action action) {
        return this.showText(value, location, XAlignmentEnum.Left, YAlignmentEnum.Top, 0.0, action);
    }

    public Quad showText(String value, Point2D location, XAlignmentEnum xAlignment, YAlignmentEnum yAlignment, double rotation) {
        Quad frame;
        ContentScanner.GraphicsState state = this.scanner.getState();
        Font font = state.getFont();
        double fontSize = state.getFontSize();
        double x = location.getX();
        double y = location.getY();
        double width = font.getKernedWidth(value, fontSize);
        double height = font.getLineHeight(fontSize);
        double descent = font.getDescent(fontSize);
        if (xAlignment == XAlignmentEnum.Left && yAlignment == YAlignmentEnum.Top) {
            this.beginText();
            try {
                if (rotation == 0.0) {
                    this.translateText(x, this.scanner.getContentContext().getBox().getHeight() - y - font.getAscent(fontSize));
                } else {
                    double rad = rotation * Math.PI / 180.0;
                    double cos = Math.cos(rad);
                    double sin = Math.sin(rad);
                    this.setTextMatrix(cos, sin, -sin, cos, x, this.scanner.getContentContext().getBox().getHeight() - y - font.getAscent(fontSize));
                }
                state = this.scanner.getState();
                frame = new Quad(state.textToDeviceSpace(new Point2D.Double(0.0, descent), true), state.textToDeviceSpace(new Point2D.Double(width, descent), true), state.textToDeviceSpace(new Point2D.Double(width, height + descent), true), state.textToDeviceSpace(new Point2D.Double(0.0, height + descent), true));
                this.add(new ShowSimpleText(font.encode(value)));
            }
            finally {
                this.end();
            }
        }
        this.beginLocalState();
        try {
            double sin;
            double cos;
            if (rotation == 0.0) {
                cos = 1.0;
                sin = 0.0;
            } else {
                double rad = rotation * Math.PI / 180.0;
                cos = Math.cos(rad);
                sin = Math.sin(rad);
            }
            this.applyMatrix(cos, sin, -sin, cos, x, this.scanner.getContentContext().getBox().getHeight() - y);
            this.beginText();
            try {
                switch (xAlignment) {
                    case Left: {
                        x = 0.0;
                        break;
                    }
                    case Right: {
                        x = -width;
                        break;
                    }
                    case Center: 
                    case Justify: {
                        x = -width / 2.0;
                    }
                }
                switch (yAlignment) {
                    case Top: {
                        y = -font.getAscent(fontSize);
                        break;
                    }
                    case Bottom: {
                        y = height - font.getAscent(fontSize);
                        break;
                    }
                    case Middle: {
                        y = height / 2.0 - font.getAscent(fontSize);
                    }
                }
                this.translateText(x, y);
                state = this.scanner.getState();
                frame = new Quad(state.textToDeviceSpace(new Point2D.Double(0.0, descent), true), state.textToDeviceSpace(new Point2D.Double(width, descent), true), state.textToDeviceSpace(new Point2D.Double(width, height + descent), true), state.textToDeviceSpace(new Point2D.Double(0.0, height + descent), true));
                this.add(new ShowSimpleText(font.encode(value)));
            }
            finally {
                this.end();
            }
        }
        finally {
            this.end();
        }
        return frame;
    }

    public Link showText(String value, Point2D location, XAlignmentEnum xAlignment, YAlignmentEnum yAlignment, double rotation, Action action) {
        IContentContext contentContext = this.scanner.getContentContext();
        if (!(contentContext instanceof Page)) {
            throw new RuntimeException("Links can be shown only on page contexts.");
        }
        Rectangle2D linkBox = this.showText(value, location, xAlignment, yAlignment, rotation).getBounds2D();
        return new Link((Page)contentContext, linkBox, null, action);
    }

    public void showXObject(PdfName name) {
        this.add(new PaintXObject(name));
    }

    public void showXObject(XObject value) {
        this.showXObject(this.getResourceName(value));
    }

    public void showXObject(PdfName name, Point2D location) {
        this.showXObject(name, location, null);
    }

    public void showXObject(XObject value, Point2D location) {
        this.showXObject(this.getResourceName(value), location);
    }

    public void showXObject(PdfName name, Point2D location, Dimension2D size) {
        this.showXObject(name, location, size, XAlignmentEnum.Left, YAlignmentEnum.Top, 0.0);
    }

    public void showXObject(XObject value, Point2D location, Dimension2D size) {
        this.showXObject(this.getResourceName(value), location, size);
    }

    public void showXObject(PdfName name, Point2D location, Dimension2D size, XAlignmentEnum xAlignment, YAlignmentEnum yAlignment, double rotation) {
        double locationOffsetY;
        double locationOffsetX;
        XObject xObject = (XObject)this.scanner.getContentContext().getResources().getXObjects().get(name);
        Dimension2D xObjectSize = xObject.getSize();
        if (size == null) {
            size = xObjectSize;
        }
        AffineTransform matrix = xObject.getMatrix();
        double scaleX = size.getWidth() / (xObjectSize.getWidth() * matrix.getScaleX());
        double scaleY = size.getHeight() / (xObjectSize.getHeight() * matrix.getScaleY());
        switch (xAlignment) {
            case Left: {
                locationOffsetX = 0.0;
                break;
            }
            case Right: {
                locationOffsetX = size.getWidth();
                break;
            }
            default: {
                locationOffsetX = size.getWidth() / 2.0;
            }
        }
        switch (yAlignment) {
            case Top: {
                locationOffsetY = size.getHeight();
                break;
            }
            case Bottom: {
                locationOffsetY = 0.0;
                break;
            }
            default: {
                locationOffsetY = size.getHeight() / 2.0;
            }
        }
        this.beginLocalState();
        try {
            this.translate(location.getX(), this.scanner.getContentContext().getBox().getHeight() - location.getY());
            if (rotation != 0.0) {
                this.rotate(rotation);
            }
            this.applyMatrix(scaleX, 0.0, 0.0, scaleY, -locationOffsetX, -locationOffsetY);
            this.showXObject(name);
        }
        finally {
            this.end();
        }
    }

    public void showXObject(XObject value, Point2D location, Dimension2D size, XAlignmentEnum xAlignment, YAlignmentEnum yAlignment, double rotation) {
        this.showXObject(this.getResourceName(value), location, size, xAlignment, yAlignment, rotation);
    }

    public void startPath(Point2D startPoint) {
        this.add(new BeginSubpath(startPoint.getX(), this.scanner.getContentContext().getBox().getHeight() - startPoint.getY()));
    }

    public void stroke() {
        this.add(PaintPath.Stroke);
    }

    public void translate(double distanceX, double distanceY) {
        this.applyMatrix(1.0, 0.0, 0.0, 1.0, distanceX, distanceY);
    }

    private void applyState_(PdfName name) {
        this.add(new ApplyExtGState(name));
    }

    private MarkedContent beginMarkedContent_(PdfName tag, PdfName propertyListName) {
        return (MarkedContent)this.begin(new MarkedContent(new BeginMarkedContent(tag, (PdfDirectObject)propertyListName)));
    }

    private Text beginText() {
        return (Text)this.begin(new Text());
    }

    private void drawArc(RectangularShape location, double startAngle, double endAngle, double branchWidth, double branchRatio, boolean beginPath) {
        if (startAngle > endAngle) {
            double swap = startAngle;
            startAngle = endAngle;
            endAngle = swap;
        }
        double radiusX = location.getWidth() / 2.0;
        double radiusY = location.getHeight() / 2.0;
        Point2D.Double center = new Point2D.Double(location.getX() + radiusX, location.getY() + radiusY);
        double radians1 = Math.toRadians(startAngle);
        Point2D.Double point1 = new Point2D.Double(((Point2D)center).getX() + Math.cos(radians1) * radiusX, ((Point2D)center).getY() - Math.sin(radians1) * radiusY);
        if (beginPath) {
            this.startPath(point1);
        }
        double endRadians = Math.toRadians(endAngle);
        double quadrantRadians = 1.5707963267948966;
        double radians2 = Math.min(radians1 + 1.5707963267948966 - radians1 % 1.5707963267948966, endRadians);
        double kappa = 0.5522847498;
        while (true) {
            double segmentX = radiusX * 0.5522847498;
            double segmentY = radiusY * 0.5522847498;
            Point2D.Double point2 = new Point2D.Double(((Point2D)center).getX() + Math.cos(radians2) * radiusX, ((Point2D)center).getY() - Math.sin(radians2) * radiusY);
            double tangentialRadians1 = Math.atan(-(Math.pow(radiusY, 2.0) * (((Point2D)point1).getX() - ((Point2D)center).getX())) / (Math.pow(radiusX, 2.0) * (((Point2D)point1).getY() - ((Point2D)center).getY())));
            double segment1 = (segmentY * (1.0 - Math.abs(Math.sin(radians1))) + segmentX * (1.0 - Math.abs(Math.cos(radians1)))) * (radians2 - radians1) / 1.5707963267948966;
            Point2D.Double control1 = new Point2D.Double(((Point2D)point1).getX() + Math.abs(Math.cos(tangentialRadians1) * segment1) * Math.signum(-Math.sin(radians1)), ((Point2D)point1).getY() + Math.abs(Math.sin(tangentialRadians1) * segment1) * Math.signum(-Math.cos(radians1)));
            double tangentialRadians2 = Math.atan(-(Math.pow(radiusY, 2.0) * (((Point2D)point2).getX() - ((Point2D)center).getX())) / (Math.pow(radiusX, 2.0) * (((Point2D)point2).getY() - ((Point2D)center).getY())));
            double segment2 = (segmentY * (1.0 - Math.abs(Math.sin(radians2))) + segmentX * (1.0 - Math.abs(Math.cos(radians2)))) * (radians2 - radians1) / 1.5707963267948966;
            Point2D.Double control2 = new Point2D.Double(((Point2D)point2).getX() + Math.abs(Math.cos(tangentialRadians2) * segment2) * Math.signum(Math.sin(radians2)), ((Point2D)point2).getY() + Math.abs(Math.sin(tangentialRadians2) * segment2) * Math.signum(Math.cos(radians2)));
            this.drawCurve(point2, control1, control2);
            if (radians2 == endRadians) break;
            point1 = point2;
            radians1 = radians2;
            if ((radians2 += 1.5707963267948966) > endRadians) {
                radians2 = endRadians;
            }
            double quadrantRatio = (radians2 - radians1) / 1.5707963267948966;
            radiusX += branchWidth * quadrantRatio;
            radiusY += branchWidth * quadrantRatio;
            branchWidth *= branchRatio;
        }
    }

    private <T extends PdfObjectWrapper<?>> PdfName getResourceName(T value) {
        if (value instanceof DeviceGrayColorSpace) {
            return PdfName.DeviceGray;
        }
        if (value instanceof DeviceRGBColorSpace) {
            return PdfName.DeviceRGB;
        }
        if (value instanceof DeviceCMYKColorSpace) {
            return PdfName.DeviceCMYK;
        }
        Map resourceItems = this.scanner.getContentContext().getResources().get((Class)value.getClass());
        PdfName name = ((PdfDictionary)((PdfObjectWrapper)((Object)resourceItems)).getBaseDataObject()).getKey(value.getBaseObject());
        if (name == null) {
            int resourceIndex = ((ResourceItems)resourceItems).size();
            while (((ResourceItems)resourceItems).containsKey(name = new PdfName(String.valueOf(++resourceIndex)))) {
            }
            ((ResourceItems)resourceItems).put(name, value);
        }
        return name;
    }

    private void rotateText(double angle) {
        double rad = angle * Math.PI / 180.0;
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        this.setTextMatrix(cos, sin, -sin, cos, 0.0, 0.0);
    }

    private void scaleText(double ratioX, double ratioY) {
        this.setTextMatrix(ratioX, 0.0, 0.0, ratioY, 0.0, 0.0);
    }

    private void setFont_(PdfName name, double size) {
        this.add(new SetFont(name, size));
    }

    private void setTextMatrix(double a, double b, double c, double d, double e, double f) {
        this.add(new SetTextMatrix(a, b, c, d, e, f));
    }

    private void translateText(double distanceX, double distanceY) {
        this.setTextMatrix(1.0, 0.0, 0.0, 1.0, distanceX, distanceY);
    }

    private void translateTextRelative(double offsetX, double offsetY) {
        this.add(new TranslateTextRelative(offsetX, -offsetY));
    }

    private void translateTextToNextLine() {
        this.add(TranslateTextToNextLine.Value);
    }
}

