/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.fonts;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.documents.contents.fonts.CMapParser;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.util.ByteArray;

final class CMap {
    public static Map<ByteArray, Integer> get(IInputStream stream) {
        CMapParser parser = new CMapParser(stream);
        return parser.parse();
    }

    public static Map<ByteArray, Integer> get(PdfDataObject encodingObject) {
        if (encodingObject == null) {
            return null;
        }
        if (encodingObject instanceof PdfName) {
            return CMap.get((PdfName)encodingObject);
        }
        if (encodingObject instanceof PdfStream) {
            return CMap.get((PdfStream)encodingObject);
        }
        throw new UnsupportedOperationException("Unknown encoding object type: " + encodingObject.getClass().getSimpleName());
    }

    public static Map<ByteArray, Integer> get(PdfStream stream) {
        return CMap.get(stream.getBody());
    }

    public static Map<ByteArray, Integer> get(PdfName name) {
        return CMap.get(name.getValue());
    }

    public static Map<ByteArray, Integer> get(String name) {
        InputStream cmapResourceStream = CMap.class.getResourceAsStream("/fonts/cmap/" + name);
        if (cmapResourceStream == null) {
            return null;
        }
        BufferedReader cmapStream = new BufferedReader(new InputStreamReader(cmapResourceStream));
        Map<ByteArray, Integer> cmap = CMap.get(new Buffer(cmapStream));
        return cmap;
    }

    private CMap() {
    }
}

