/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.fonts;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.documents.contents.fonts.GlyphMapping;
import org.pdfclown.util.NotImplementedException;

final class CffParser {
    private static final List<String> StandardStrings = new ArrayList<String>();
    public Map<Integer, Integer> glyphIndexes;
    private final IInputStream fontData;
    private Index stringIndex;

    static {
        BufferedReader stream = null;
        try {
            try {
                String line;
                stream = new BufferedReader(new InputStreamReader(CffParser.class.getResourceAsStream("/fonts/cff/StandardStrings")));
                while ((line = stream.readLine()) != null) {
                    StandardStrings.add(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String toString(byte[] data) throws UnsupportedEncodingException {
        return new String(data, "ISO-8859-1");
    }

    CffParser(IInputStream fontData) {
        this.fontData = fontData;
        this.load();
    }

    private void load() {
        try {
            this.parseHeader();
            Index nameIndex = Index.parse(this.fontData);
            Index topDictIndex = Index.parse(this.fontData);
            this.stringIndex = Index.parse(this.fontData);
            Index globalSubrIndex = Index.parse(this.fontData);
            String fontName = CffParser.toString(nameIndex.get(0));
            Dict topDict = Dict.parse(topDictIndex.get(0));
            int charstringType = topDict.get(Dict.OperatorEnum.CharstringType, 0, 2).intValue();
            int charStringsOffset = topDict.get(Dict.OperatorEnum.CharStrings, 0).intValue();
            Index charStringsIndex = Index.parse(this.fontData, charStringsOffset);
            int charsetOffset = topDict.get(Dict.OperatorEnum.Charset, 0, 0).intValue();
            StandardCharsetEnum charset = StandardCharsetEnum.get(charsetOffset);
            if (charset != null) {
                this.glyphIndexes = new HashMap<Integer, Integer>(charset.getMap());
            } else {
                this.glyphIndexes = new HashMap<Integer, Integer>();
                this.fontData.setPosition(charsetOffset);
                int charsetFormat = this.fontData.readUnsignedByte();
                int index = 1;
                int count = charStringsIndex.size();
                block6: while (index <= count) {
                    switch (charsetFormat) {
                        case 0: {
                            this.glyphIndexes.put(index++, this.toUnicode(this.fontData.readUnsignedShort()));
                            break;
                        }
                        case 1: 
                        case 2: {
                            int first = this.fontData.readUnsignedShort();
                            int nLeft = charsetFormat == 1 ? this.fontData.readUnsignedByte() : this.fontData.readUnsignedShort();
                            int rangeItemIndex = first;
                            int rangeItemEndIndex = first + nLeft;
                            while (rangeItemIndex <= rangeItemEndIndex) {
                                this.glyphIndexes.put(index++, this.toUnicode(rangeItemIndex));
                                ++rangeItemIndex;
                            }
                            continue block6;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getString(int id) throws UnsupportedEncodingException {
        return id < StandardStrings.size() ? StandardStrings.get(id) : CffParser.toString(this.stringIndex.get(id - StandardStrings.size()));
    }

    private void parseHeader() throws EOFException {
        this.fontData.seek(2L);
        int hdrSize = this.fontData.readUnsignedByte();
        this.fontData.seek(hdrSize);
    }

    private int toUnicode(int sid) throws UnsupportedEncodingException {
        Integer code = GlyphMapping.nameToCode(this.getString(sid));
        if (code == null) {
            code = sid;
        }
        return code;
    }

    private static final class Dict
    implements Map<Integer, List<Number>> {
        private static final int OperatorValueEscape = 3072;
        private final Map<Integer, List<Number>> entries;

        public static Dict parse(byte[] data) throws EOFException {
            return Dict.parse(new Buffer(data));
        }

        public static Dict parse(IInputStream stream) throws EOFException {
            HashMap<Integer, List<Number>> entries = new HashMap<Integer, List<Number>>();
            ArrayList<Number> operands = null;
            while (true) {
                int b0;
                try {
                    b0 = stream.readUnsignedByte();
                }
                catch (EOFException e) {
                    break;
                }
                if (b0 >= 0 && b0 <= 21) {
                    int operator = b0;
                    if (b0 == 12) {
                        operator <<= 8 + stream.readUnsignedByte();
                    }
                    entries.put(operator, operands);
                    operands = null;
                    continue;
                }
                if (operands == null) {
                    operands = new ArrayList<Number>();
                }
                if (b0 == 28) {
                    operands.add(stream.readUnsignedByte() << 8 + stream.readUnsignedByte());
                    continue;
                }
                if (b0 == 29) {
                    operands.add(stream.readUnsignedByte() << 24 + stream.readUnsignedByte() << 16 + stream.readUnsignedByte() << 8 + stream.readUnsignedByte());
                    continue;
                }
                if (b0 == 30) {
                    StringBuilder operandBuilder = new StringBuilder();
                    boolean ended = false;
                    do {
                        int[] nibbles;
                        int b = stream.readUnsignedByte();
                        int[] nArray = nibbles = new int[]{b >> 4 & 0xF, b & 0xF};
                        int n = nibbles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int nibble = nArray[n2];
                            switch (nibble) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: {
                                    operandBuilder.append(nibble);
                                    break;
                                }
                                case 10: {
                                    operandBuilder.append(".");
                                    break;
                                }
                                case 11: {
                                    operandBuilder.append("E");
                                    break;
                                }
                                case 12: {
                                    operandBuilder.append("E-");
                                    break;
                                }
                                case 13: {
                                    break;
                                }
                                case 14: {
                                    operandBuilder.append("-");
                                    break;
                                }
                                case 15: {
                                    ended = true;
                                }
                            }
                            ++n2;
                        }
                    } while (!ended);
                    operands.add(Double.valueOf(operandBuilder.toString()));
                    continue;
                }
                if (b0 >= 32 && b0 <= 246) {
                    operands.add(b0 - 139);
                    continue;
                }
                if (b0 >= 247 && b0 <= 250) {
                    operands.add(b0 - 247 << 8 + stream.readUnsignedByte() + 108);
                    continue;
                }
                if (b0 < 251 || b0 > 254) continue;
                operands.add(-(b0 - 251) << 8 - stream.readUnsignedByte() - 108);
            }
            return new Dict(entries);
        }

        private Dict(Map<Integer, List<Number>> entries) {
            this.entries = entries;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.entries.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.entries.containsValue(value);
        }

        @Override
        public Set<Map.Entry<Integer, List<Number>>> entrySet() {
            return this.entries.entrySet();
        }

        @Override
        public List<Number> get(Object key) {
            return this.entries.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        @Override
        public Set<Integer> keySet() {
            return this.entries.keySet();
        }

        @Override
        public List<Number> put(Integer key, List<Number> value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends Integer, ? extends List<Number>> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Number> remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public Collection<List<Number>> values() {
            return this.entries.values();
        }

        public Number get(OperatorEnum operator, int operandIndex) {
            return this.get(operator, operandIndex, null);
        }

        public Number get(OperatorEnum operator, int operandIndex, Integer defaultValue) {
            Object operands = this.get(operator.getValue());
            return operands != null ? (Number)((Number)operands.get(operandIndex)) : (Number)defaultValue;
        }

        public static enum OperatorEnum {
            Charset("charset", 15),
            CharStrings(17),
            CharstringType(3078),
            Encoding(16);

            private final String name;
            private final int value;

            private OperatorEnum(int value) {
                this(null, value);
            }

            private OperatorEnum(String name, int value) {
                this.name = name;
                this.value = value;
            }

            public String getName() {
                return this.name != null ? this.name : this.name();
            }

            public int getValue() {
                return this.value;
            }
        }
    }

    private static final class Index
    implements List<byte[]> {
        private final byte[][] data;

        public static Index parse(byte[] data) throws EOFException {
            return Index.parse(new Buffer(data));
        }

        public static Index parse(IInputStream stream) throws EOFException {
            byte[][] data = new byte[stream.readUnsignedShort()][];
            int[] offsets = new int[data.length + 1];
            int offSize = stream.readUnsignedByte();
            int index = 0;
            int count = offsets.length;
            while (index < count) {
                offsets[index] = stream.readInt(offSize);
                ++index;
            }
            index = 0;
            count = data.length;
            while (index < count) {
                data[index] = new byte[offsets[index + 1] - offsets[index]];
                stream.read(data[index]);
                ++index;
            }
            return new Index(data);
        }

        public static Index parse(IInputStream stream, int offset) throws EOFException {
            stream.setPosition(offset);
            return Index.parse(stream);
        }

        private Index(byte[][] data) {
            this.data = data;
        }

        @Override
        public boolean add(byte[] item) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, byte[] item) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends byte[]> items) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends byte[]> items) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object item) {
            throw new NotImplementedException();
        }

        @Override
        public boolean containsAll(Collection<?> items) {
            throw new NotImplementedException();
        }

        @Override
        public byte[] get(int index) {
            return this.data[index];
        }

        @Override
        public int indexOf(Object item) {
            throw new NotImplementedException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<byte[]> iterator() {
            return new Iterator<byte[]>(){
                int index = -1;

                @Override
                public boolean hasNext() {
                    return this.index + 1 < Index.this.size();
                }

                @Override
                public byte[] next() {
                    return Index.this.data[++this.index];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int lastIndexOf(Object item) {
            throw new NotImplementedException();
        }

        @Override
        public ListIterator<byte[]> listIterator() {
            throw new NotImplementedException();
        }

        @Override
        public ListIterator<byte[]> listIterator(int index) {
            throw new NotImplementedException();
        }

        @Override
        public boolean remove(Object item) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> items) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> items) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] set(int index, byte[] item) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public List<byte[]> subList(int fromIndex, int toIndex) {
            throw new NotImplementedException();
        }

        @Override
        public Object[] toArray() {
            throw new NotImplementedException();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            throw new NotImplementedException();
        }
    }

    private static enum StandardCharsetEnum {
        ISOAdobe(0),
        Expert(1),
        ExpertSubset(2);

        final int id;
        final Map<Integer, Integer> map;

        public static StandardCharsetEnum get(Integer value) {
            if (value == null) {
                return ISOAdobe;
            }
            StandardCharsetEnum[] standardCharsetEnumArray = StandardCharsetEnum.values();
            int n = standardCharsetEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                StandardCharsetEnum charset = standardCharsetEnumArray[n2];
                if (value.equals(charset.getId())) {
                    return charset;
                }
                ++n2;
            }
            return null;
        }

        private StandardCharsetEnum(int id) {
            this.id = id;
            this.map = new HashMap<Integer, Integer>();
            BufferedReader stream = null;
            try {
                try {
                    String line;
                    stream = new BufferedReader(new InputStreamReader(CffParser.class.getResourceAsStream("/fonts/cff/" + this.name() + "Charset")));
                    while ((line = stream.readLine()) != null) {
                        String[] lineItems = line.split(",");
                        this.map.put(Integer.parseInt(lineItems[0]), GlyphMapping.nameToCode(lineItems[1]));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public int getId() {
            return this.id;
        }

        public Map<Integer, Integer> getMap() {
            return this.map;
        }
    }
}

