/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.fonts;

import java.io.EOFException;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.documents.contents.fonts.GlyphMapping;
import org.pdfclown.util.ByteArray;
import org.pdfclown.util.parsers.ParseException;

final class PfbParser {
    private final IInputStream stream;

    PfbParser(IInputStream stream) {
        this.stream = stream;
    }

    public Map<ByteArray, Integer> parse() {
        String key;
        String line;
        Matcher lineMatcher;
        Hashtable<ByteArray, Integer> codes = new Hashtable<ByteArray, Integer>();
        Pattern linePattern = Pattern.compile("(\\S+)\\s+(.+)");
        do {
            try {
                line = this.stream.readLine();
            }
            catch (EOFException e) {
                throw new ParseException("Encoding section not found.", e);
            }
        } while (!(lineMatcher = linePattern.matcher(line)).find() || !(key = lineMatcher.group(1)).equals("/Encoding"));
        try {
            this.stream.readLine();
        }
        catch (EOFException e) {
            throw new ParseException(e);
        }
        Pattern encodingLinePattern = Pattern.compile("dup (\\S+) (\\S+) put");
        while (true) {
            String encodingLine;
            try {
                encodingLine = this.stream.readLine();
            }
            catch (EOFException e) {
                break;
            }
            Matcher encodingLineMatcher = encodingLinePattern.matcher(encodingLine);
            if (!encodingLineMatcher.find()) break;
            byte[] inputCode = new byte[]{(byte)Integer.parseInt(encodingLineMatcher.group(1))};
            String name = encodingLineMatcher.group(2).substring(1);
            codes.put(new ByteArray(inputCode), GlyphMapping.nameToCode(name));
        }
        return codes;
    }
}

