/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.layers;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.PropertyList;
import org.pdfclown.documents.contents.layers.ILayerNode;
import org.pdfclown.documents.contents.layers.LayerConfiguration;
import org.pdfclown.documents.contents.layers.LayerDefinition;
import org.pdfclown.documents.contents.layers.LayerEntity;
import org.pdfclown.documents.contents.layers.LayerMembership;
import org.pdfclown.documents.contents.layers.Layers;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.objects.PdfTextString;
import org.pdfclown.util.math.Interval;

@PDF(value=VersionEnum.PDF15)
public final class Layer
extends LayerEntity
implements ILayerNode {
    public static final PdfName TypeName = PdfName.OCG;
    private static final PdfName MembershipName = new PdfName("D-OCMD");

    public static Layer wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new Layer(baseObject) : null;
    }

    public Layer(Document context, String title) {
        super(context, PdfName.OCG);
        this.setTitle(title);
        LayerDefinition definition = context.getLayer();
        if (definition == null) {
            definition = new LayerDefinition(context);
            context.setLayer(definition);
        }
        definition.getAllLayersObject().add(this.getBaseObject());
    }

    private Layer(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Layer clone(Document context) {
        return (Layer)super.clone(context);
    }

    public String getContentType() {
        return (String)PdfSimpleObject.getValue(this.getUsageEntry(PdfName.CreatorInfo).get(PdfName.Subtype));
    }

    public String getCreator() {
        return (String)PdfSimpleObject.getValue(this.getUsageEntry(PdfName.CreatorInfo).get(PdfName.Creator));
    }

    public String getLanguage() {
        return (String)PdfSimpleObject.getValue(this.getUsageEntry(PdfName.Language).get(PdfName.Lang));
    }

    @Override
    public Layers getLayers() {
        LayersLocation location = this.findLayersLocation();
        return Layers.wrap(location.parentLayersObject.get(location.index, PdfArray.class));
    }

    @Override
    public LayerMembership getMembership() {
        LayerMembership membership;
        PdfDirectObject membershipObject = ((PdfDictionary)this.getBaseDataObject()).get(MembershipName);
        if (membershipObject == null) {
            membership = new LayerMembership(this.getDocument());
            membership.setVisibilityPolicy(LayerEntity.VisibilityPolicyEnum.AllOn);
            membershipObject = membership.getBaseObject();
            ((PdfDictionary)this.getBaseDataObject()).put(MembershipName, membershipObject);
        } else {
            membership = LayerMembership.wrap(membershipObject);
        }
        if (membership.getVisibilityLayers().isEmpty()) {
            membership.getVisibilityLayers().add(this);
            LayersLocation location = this.findLayersLocation();
            if (location.parentLayerObject != null) {
                membership.getVisibilityLayers().add(new Layer(location.parentLayerObject));
            }
            for (Object[] level : location.levels) {
                PdfDirectObject layerObject = (PdfDirectObject)level[2];
                if (layerObject == null) continue;
                membership.getVisibilityLayers().add(new Layer(layerObject));
            }
        }
        return membership;
    }

    @Override
    public List<Layer> getVisibilityLayers() {
        return this.getMembership().getVisibilityLayers();
    }

    @Override
    public LayerEntity.VisibilityPolicyEnum getVisibilityPolicy() {
        return this.getMembership().getVisibilityPolicy();
    }

    public Interval<Double> getZoomRange() {
        PdfDictionary zoomDictionary = this.getUsageEntry(PdfName.Zoom);
        PdfNumber minObject = (PdfNumber)zoomDictionary.resolve(PdfName.min);
        PdfNumber maxObject = (PdfNumber)zoomDictionary.resolve(PdfName.max);
        return new Interval<Double>(minObject != null ? minObject.getDoubleValue() : 0.0, maxObject != null ? maxObject.getDoubleValue() : Double.POSITIVE_INFINITY);
    }

    public boolean isExportable() {
        return StateEnum.valueOf((PdfName)this.getUsageEntry(PdfName.Export).get(PdfName.ExportState)).isEnabled();
    }

    public boolean isLocked() {
        return ((PdfDictionary)this.getDefaultConfiguration().getBaseDataObject()).resolve(PdfName.Locked, PdfArray.class).contains(this.getBaseObject());
    }

    public boolean isPrintable() {
        return StateEnum.valueOf((PdfName)this.getUsageEntry(PdfName.Print).get(PdfName.PrintState)).isEnabled();
    }

    public boolean isViewable() {
        return StateEnum.valueOf((PdfName)this.getUsageEntry(PdfName.View).get(PdfName.ViewState)).isEnabled();
    }

    public boolean isVisible() {
        return this.getDefaultConfiguration().isVisible(this);
    }

    public void setContentType(String value) {
        this.getUsageEntry(PdfName.CreatorInfo).put(PdfName.Subtype, PdfName.get(value));
    }

    public void setCreator(String value) {
        this.getUsageEntry(PdfName.CreatorInfo).put(PdfName.Creator, PdfTextString.get(value));
    }

    public void setExportable(boolean value) {
        this.getUsageEntry(PdfName.Export).put(PdfName.ExportState, StateEnum.valueOf(value).getName());
        this.getDefaultConfiguration().setUsageApplication(PdfName.Export, PdfName.Export, this, true);
    }

    public void setLanguage(String value) {
        this.getUsageEntry(PdfName.Language).put(PdfName.Lang, PdfTextString.get(value));
    }

    public void setLayers(Layers value) {
        LayersLocation location = this.findLayersLocation();
        if (location.index == location.parentLayersObject.size()) {
            location.parentLayersObject.add(value.getBaseObject());
        } else if (location.parentLayersObject.resolve(location.index) instanceof PdfArray) {
            location.parentLayersObject.set(location.index, value.getBaseObject());
        } else {
            location.parentLayersObject.add(location.index, value.getBaseObject());
        }
    }

    public void setLocked(boolean value) {
        PdfArray lockedArrayObject = ((PdfDictionary)this.getDefaultConfiguration().getBaseDataObject()).resolve(PdfName.Locked, PdfArray.class);
        if (!lockedArrayObject.contains(this.getBaseObject())) {
            lockedArrayObject.add(this.getBaseObject());
        }
    }

    public void setPrintable(boolean value) {
        this.getUsageEntry(PdfName.Print).put(PdfName.PrintState, StateEnum.valueOf(value).getName());
        this.getDefaultConfiguration().setUsageApplication(PdfName.Print, PdfName.Print, this, true);
    }

    public void setViewable(boolean value) {
        this.getUsageEntry(PdfName.View).put(PdfName.ViewState, StateEnum.valueOf(value).getName());
        this.getDefaultConfiguration().setUsageApplication(PdfName.View, PdfName.View, this, true);
    }

    @Override
    public void setVisibilityPolicy(LayerEntity.VisibilityPolicyEnum value) {
        if (!value.equals((Object)this.getMembership().getVisibilityPolicy())) {
            throw new UnsupportedOperationException("Single layers cannot manage custom state policies; use LayerMembership instead.");
        }
    }

    public void setVisible(boolean value) {
        this.getDefaultConfiguration().setVisible(this, value);
    }

    public void setZoomRange(Interval<Double> value) {
        if (value != null) {
            PdfDictionary zoomDictionary = this.getUsageEntry(PdfName.Zoom);
            zoomDictionary.put(PdfName.min, value.getLow() != 0.0 ? PdfReal.get(value.getLow()) : null);
            zoomDictionary.put(PdfName.max, value.getHigh() != Double.POSITIVE_INFINITY ? PdfReal.get(value.getHigh()) : null);
        } else {
            this.getUsage().remove(PdfName.Zoom);
        }
        this.getDefaultConfiguration().setUsageApplication(PdfName.View, PdfName.Zoom, this, value != null);
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public String getTitle() {
        return ((PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Name)).getValue();
    }

    @Override
    public void setTitle(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Name, new PdfTextString(value));
    }

    private LayersLocation findLayersLocation() {
        LayersLocation location = this.findLayersLocation(this.getDefaultConfiguration());
        if (location == null) {
            Layers rootLayers = this.getDefaultConfiguration().getLayers();
            rootLayers.add(this);
            location = new LayersLocation(null, (PdfArray)rootLayers.getBaseDataObject(), rootLayers.size(), new Stack<Object[]>());
        }
        return location;
    }

    private LayersLocation findLayersLocation(LayerConfiguration configuration) {
        PdfDirectObject levelLayerObject = null;
        PdfArray levelObject = (PdfArray)configuration.getLayers().getBaseDataObject();
        Iterator<PdfDirectObject> levelIterator = levelObject.iterator();
        Stack<Object[]> levelIterators = new Stack<Object[]>();
        PdfDirectObject thisObject = this.getBaseObject();
        PdfDirectObject currentLayerObject = null;
        while (true) {
            if (!levelIterator.hasNext()) {
                if (levelIterators.isEmpty()) break;
                Object[] levelItems = (Object[])levelIterators.pop();
                levelObject = (PdfArray)levelItems[0];
                levelIterator = (Iterator<PdfDirectObject>)levelItems[1];
                levelLayerObject = (PdfDirectObject)levelItems[2];
                currentLayerObject = null;
                continue;
            }
            PdfDirectObject nodeObject = levelIterator.next();
            PdfDataObject nodeDataObject = PdfObject.resolve(nodeObject);
            if (nodeDataObject instanceof PdfDictionary) {
                if (nodeObject.equals(thisObject)) {
                    return new LayersLocation(levelLayerObject, levelObject, levelObject.indexOf(thisObject) + 1, levelIterators);
                }
                currentLayerObject = nodeObject;
                continue;
            }
            if (!(nodeDataObject instanceof PdfArray)) continue;
            levelIterators.push(new Object[]{levelObject, levelIterator, levelLayerObject});
            levelObject = (PdfArray)nodeDataObject;
            levelIterator = levelObject.iterator();
            levelLayerObject = currentLayerObject;
            currentLayerObject = null;
        }
        return null;
    }

    private LayerConfiguration getDefaultConfiguration() {
        return this.getDocument().getLayer().getDefaultConfiguration();
    }

    private PdfDictionary getUsage() {
        return ((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.Usage, PdfDictionary.class);
    }

    private PdfDictionary getUsageEntry(PdfName key) {
        return this.getUsage().resolve(key, PdfDictionary.class);
    }

    public static /* bridge */ /* synthetic */ PropertyList wrap(PdfDirectObject pdfDirectObject) {
        return Layer.wrap(pdfDirectObject);
    }

    private static class LayersLocation {
        final int index;
        final PdfDirectObject parentLayerObject;
        final PdfArray parentLayersObject;
        final Stack<Object[]> levels;

        public LayersLocation(PdfDirectObject parentLayerObject, PdfArray parentLayersObject, int index, Stack<Object[]> levels) {
            this.parentLayerObject = parentLayerObject;
            this.parentLayersObject = parentLayersObject;
            this.index = index;
            this.levels = levels;
        }
    }

    private static enum StateEnum {
        On(PdfName.ON, true),
        Off(PdfName.OFF, false);

        private boolean enabled;
        private PdfName name;

        public static StateEnum valueOf(Boolean enabled) {
            if (enabled == null) {
                return On;
            }
            StateEnum[] stateEnumArray = StateEnum.values();
            int n = stateEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                StateEnum value = stateEnumArray[n2];
                if (enabled.equals(value.isEnabled())) {
                    return value;
                }
                ++n2;
            }
            throw new UnsupportedOperationException();
        }

        private StateEnum(PdfName name, boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }

        public PdfName getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public static StateEnum valueOf(String string) {
            return Enum.valueOf(StateEnum.class, string);
        }
    }
}

