/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.layers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.PropertyList;
import org.pdfclown.documents.contents.layers.Layer;
import org.pdfclown.documents.contents.layers.LayerEntity;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF15)
public final class LayerMembership
extends LayerEntity {
    public static final PdfName TypeName = PdfName.OCMD;

    public static LayerMembership wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new LayerMembership(baseObject) : null;
    }

    public LayerMembership(Document context) {
        super(context, TypeName);
    }

    private LayerMembership(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public LayerMembership clone(Document context) {
        return (LayerMembership)super.clone(context);
    }

    @Override
    public LayerMembership getMembership() {
        return this;
    }

    @Override
    public List<Layer> getVisibilityLayers() {
        return new VisibilityLayers(this);
    }

    @Override
    public LayerEntity.VisibilityPolicyEnum getVisibilityPolicy() {
        return LayerEntity.VisibilityPolicyEnum.valueOf((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.P));
    }

    @Override
    public void setVisibilityPolicy(LayerEntity.VisibilityPolicyEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.P, value.getName());
    }

    public static /* bridge */ /* synthetic */ PropertyList wrap(PdfDirectObject pdfDirectObject) {
        return LayerMembership.wrap(pdfDirectObject);
    }

    private static class VisibilityLayers
    extends PdfObjectWrapper<PdfDirectObject>
    implements List<Layer> {
        private final LayerMembership membership;

        private VisibilityLayers(LayerMembership membership) {
            super(((PdfDictionary)membership.getBaseDataObject()).get(PdfName.OCGs));
            this.membership = membership;
        }

        @Override
        public VisibilityLayers clone(Document context) {
            return (VisibilityLayers)super.clone(context);
        }

        @Override
        public boolean add(Layer item) {
            return this.ensureArray().add(item.getBaseObject());
        }

        @Override
        public void add(int index, Layer item) {
            this.ensureArray().add(index, item.getBaseObject());
        }

        @Override
        public boolean addAll(Collection<? extends Layer> items) {
            for (Layer layer : items) {
                this.add(layer);
            }
            return !items.isEmpty();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Layer> items) {
            for (Layer layer : items) {
                this.add(index++, layer);
            }
            return !items.isEmpty();
        }

        @Override
        public void clear() {
            this.ensureArray().clear();
        }

        @Override
        public boolean contains(Object item) {
            Object baseDataObject = this.getBaseDataObject();
            if (baseDataObject == null) {
                return false;
            }
            if (baseDataObject instanceof PdfDictionary) {
                return ((Layer)item).getBaseObject().equals(this.getBaseObject());
            }
            return ((PdfArray)baseDataObject).contains(((Layer)item).getBaseObject());
        }

        @Override
        public boolean containsAll(Collection<?> items) {
            for (Object item : items) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Layer get(int index) {
            Object baseDataObject = this.getBaseDataObject();
            if (baseDataObject == null) {
                return null;
            }
            if (baseDataObject instanceof PdfDictionary) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return Layer.wrap(this.getBaseObject());
            }
            return Layer.wrap(((PdfArray)baseDataObject).get(index));
        }

        @Override
        public int indexOf(Object item) {
            Object baseDataObject = this.getBaseDataObject();
            if (baseDataObject == null) {
                return -1;
            }
            if (baseDataObject instanceof PdfDictionary) {
                return ((Layer)item).getBaseObject().equals(this.getBaseObject()) ? 0 : -1;
            }
            return ((PdfArray)baseDataObject).indexOf(((Layer)item).getBaseObject());
        }

        @Override
        public boolean isEmpty() {
            Object baseDataObject = this.getBaseDataObject();
            if (baseDataObject == null) {
                return true;
            }
            if (baseDataObject instanceof PdfDictionary) {
                return false;
            }
            return ((PdfArray)baseDataObject).isEmpty();
        }

        @Override
        public Iterator<Layer> iterator() {
            return new Iterator<Layer>(){
                private int index = 0;
                private final int size;
                {
                    this.size = VisibilityLayers.this.size();
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.size;
                }

                @Override
                public Layer next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return VisibilityLayers.this.get(this.index++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int lastIndexOf(Object item) {
            Object baseDataObject = this.getBaseDataObject();
            if (baseDataObject == null) {
                return -1;
            }
            if (baseDataObject instanceof PdfDictionary) {
                return ((Layer)item).getBaseObject().equals(this.getBaseObject()) ? 0 : -1;
            }
            return ((PdfArray)baseDataObject).lastIndexOf(((Layer)item).getBaseObject());
        }

        @Override
        public ListIterator<Layer> listIterator() {
            throw new NotImplementedException();
        }

        @Override
        public ListIterator<Layer> listIterator(int index) {
            throw new NotImplementedException();
        }

        @Override
        public boolean remove(Object item) {
            return this.ensureArray().remove(((Layer)item).getBaseObject());
        }

        @Override
        public Layer remove(int index) {
            return Layer.wrap(this.ensureArray().remove(index));
        }

        @Override
        public boolean removeAll(Collection<?> items) {
            boolean changed = false;
            for (Object item : items) {
                changed |= this.remove(item);
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> items) {
            throw new NotImplementedException();
        }

        @Override
        public Layer set(int index, Layer item) {
            return Layer.wrap(this.ensureArray().set(index, item.getBaseObject()));
        }

        @Override
        public int size() {
            Object baseDataObject = this.getBaseDataObject();
            if (baseDataObject == null) {
                return 0;
            }
            if (baseDataObject instanceof PdfDictionary) {
                return 1;
            }
            return ((PdfArray)baseDataObject).size();
        }

        @Override
        public List<Layer> subList(int fromIndex, int toIndex) {
            throw new NotImplementedException();
        }

        @Override
        public Object[] toArray() {
            throw new NotImplementedException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new NotImplementedException();
        }

        private PdfArray ensureArray() {
            PdfDirectObject baseDataObject = (PdfDirectObject)this.getBaseDataObject();
            if (!(baseDataObject instanceof PdfArray)) {
                PdfArray array = new PdfArray();
                if (baseDataObject != null) {
                    array.add(baseDataObject);
                }
                baseDataObject = array;
                this.setBaseObject(baseDataObject);
                ((PdfDictionary)this.membership.getBaseDataObject()).put(PdfName.OCGs, this.getBaseObject());
            }
            return (PdfArray)baseDataObject;
        }
    }
}

