/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.util.ArrayList;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.objects.ApplyExtGState;
import org.pdfclown.documents.contents.objects.BeginInlineImage;
import org.pdfclown.documents.contents.objects.BeginMarkedContent;
import org.pdfclown.documents.contents.objects.BeginSubpath;
import org.pdfclown.documents.contents.objects.BeginText;
import org.pdfclown.documents.contents.objects.CloseSubpath;
import org.pdfclown.documents.contents.objects.ContentObject;
import org.pdfclown.documents.contents.objects.DrawCurve;
import org.pdfclown.documents.contents.objects.DrawLine;
import org.pdfclown.documents.contents.objects.DrawRectangle;
import org.pdfclown.documents.contents.objects.EndInlineImage;
import org.pdfclown.documents.contents.objects.EndMarkedContent;
import org.pdfclown.documents.contents.objects.EndText;
import org.pdfclown.documents.contents.objects.GenericOperation;
import org.pdfclown.documents.contents.objects.MarkedContentPoint;
import org.pdfclown.documents.contents.objects.ModifyCTM;
import org.pdfclown.documents.contents.objects.ModifyClipPath;
import org.pdfclown.documents.contents.objects.PaintPath;
import org.pdfclown.documents.contents.objects.PaintShading;
import org.pdfclown.documents.contents.objects.PaintXObject;
import org.pdfclown.documents.contents.objects.RestoreGraphicsState;
import org.pdfclown.documents.contents.objects.SaveGraphicsState;
import org.pdfclown.documents.contents.objects.SetCharSpace;
import org.pdfclown.documents.contents.objects.SetDeviceCMYKFillColor;
import org.pdfclown.documents.contents.objects.SetDeviceCMYKStrokeColor;
import org.pdfclown.documents.contents.objects.SetDeviceGrayFillColor;
import org.pdfclown.documents.contents.objects.SetDeviceGrayStrokeColor;
import org.pdfclown.documents.contents.objects.SetDeviceRGBFillColor;
import org.pdfclown.documents.contents.objects.SetDeviceRGBStrokeColor;
import org.pdfclown.documents.contents.objects.SetFillColor;
import org.pdfclown.documents.contents.objects.SetFillColorSpace;
import org.pdfclown.documents.contents.objects.SetFont;
import org.pdfclown.documents.contents.objects.SetLineCap;
import org.pdfclown.documents.contents.objects.SetLineDash;
import org.pdfclown.documents.contents.objects.SetLineJoin;
import org.pdfclown.documents.contents.objects.SetLineWidth;
import org.pdfclown.documents.contents.objects.SetMiterLimit;
import org.pdfclown.documents.contents.objects.SetStrokeColor;
import org.pdfclown.documents.contents.objects.SetStrokeColorSpace;
import org.pdfclown.documents.contents.objects.SetTextLead;
import org.pdfclown.documents.contents.objects.SetTextMatrix;
import org.pdfclown.documents.contents.objects.SetTextRenderMode;
import org.pdfclown.documents.contents.objects.SetTextRise;
import org.pdfclown.documents.contents.objects.SetTextScale;
import org.pdfclown.documents.contents.objects.SetWordSpace;
import org.pdfclown.documents.contents.objects.ShowAdjustedText;
import org.pdfclown.documents.contents.objects.ShowSimpleText;
import org.pdfclown.documents.contents.objects.ShowTextToNextLine;
import org.pdfclown.documents.contents.objects.TranslateTextRelative;
import org.pdfclown.documents.contents.objects.TranslateTextToNextLine;
import org.pdfclown.files.File;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.tokens.Chunk;

@PDF(value=VersionEnum.PDF10)
public abstract class Operation
extends ContentObject {
    protected String operator;
    protected List<PdfDirectObject> operands;

    public static Operation get(String operator, List<PdfDirectObject> operands) {
        if (operator == null) {
            return null;
        }
        if (operator.equals("q")) {
            return SaveGraphicsState.Value;
        }
        if (operator.equals("Tf")) {
            return new SetFont(operands);
        }
        if (operator.equals("SC") || operator.equals("SCN")) {
            return new SetStrokeColor(operator, operands);
        }
        if (operator.equals("CS")) {
            return new SetStrokeColorSpace(operands);
        }
        if (operator.equals("sc") || operator.equals("scn")) {
            return new SetFillColor(operator, operands);
        }
        if (operator.equals("cs")) {
            return new SetFillColorSpace(operands);
        }
        if (operator.equals("G")) {
            return new SetDeviceGrayStrokeColor(operands);
        }
        if (operator.equals("g")) {
            return new SetDeviceGrayFillColor(operands);
        }
        if (operator.equals("RG")) {
            return new SetDeviceRGBStrokeColor(operands);
        }
        if (operator.equals("rg")) {
            return new SetDeviceRGBFillColor(operands);
        }
        if (operator.equals("K")) {
            return new SetDeviceCMYKStrokeColor(operands);
        }
        if (operator.equals("k")) {
            return new SetDeviceCMYKFillColor(operands);
        }
        if (operator.equals("Q")) {
            return RestoreGraphicsState.Value;
        }
        if (operator.equals("m")) {
            return new BeginSubpath(operands);
        }
        if (operator.equals("h")) {
            return CloseSubpath.Value;
        }
        if (operator.equals("s")) {
            return PaintPath.CloseStroke;
        }
        if (operator.equals("f") || operator.equals("F")) {
            return PaintPath.Fill;
        }
        if (operator.equals("f*")) {
            return PaintPath.FillEvenOdd;
        }
        if (operator.equals("S")) {
            return PaintPath.Stroke;
        }
        if (operator.equals("B")) {
            return PaintPath.FillStroke;
        }
        if (operator.equals("B*")) {
            return PaintPath.FillStrokeEvenOdd;
        }
        if (operator.equals("b")) {
            return PaintPath.CloseFillStroke;
        }
        if (operator.equals("b*")) {
            return PaintPath.CloseFillStrokeEvenOdd;
        }
        if (operator.equals("n")) {
            return PaintPath.EndPathNoOp;
        }
        if (operator.equals("W")) {
            return ModifyClipPath.NonZero;
        }
        if (operator.equals("W*")) {
            return ModifyClipPath.EvenOdd;
        }
        if (operator.equals("T*")) {
            return TranslateTextToNextLine.Value;
        }
        if (operator.equals("Tj")) {
            return new ShowSimpleText(operands);
        }
        if (operator.equals("'") || operator.equals("''")) {
            return new ShowTextToNextLine(operator, operands);
        }
        if (operator.equals("TJ")) {
            return new ShowAdjustedText(operands);
        }
        if (operator.equals("Td") || operator.equals("TD")) {
            return new TranslateTextRelative(operator, operands);
        }
        if (operator.equals("Tm")) {
            return new SetTextMatrix(operands);
        }
        if (operator.equals("cm")) {
            return new ModifyCTM(operands);
        }
        if (operator.equals("Do")) {
            return new PaintXObject(operands);
        }
        if (operator.equals("sh")) {
            return new PaintShading(operands);
        }
        if (operator.equals("Tc")) {
            return new SetCharSpace(operands);
        }
        if (operator.equals("J")) {
            return new SetLineCap(operands);
        }
        if (operator.equals("d")) {
            return new SetLineDash(operands);
        }
        if (operator.equals("j")) {
            return new SetLineJoin(operands);
        }
        if (operator.equals("w")) {
            return new SetLineWidth(operands);
        }
        if (operator.equals("M")) {
            return new SetMiterLimit(operands);
        }
        if (operator.equals("TL")) {
            return new SetTextLead(operands);
        }
        if (operator.equals("Ts")) {
            return new SetTextRise(operands);
        }
        if (operator.equals("Tz")) {
            return new SetTextScale(operands);
        }
        if (operator.equals("Tr")) {
            return new SetTextRenderMode(operands);
        }
        if (operator.equals("Tw")) {
            return new SetWordSpace(operands);
        }
        if (operator.equals("l")) {
            return new DrawLine(operands);
        }
        if (operator.equals("re")) {
            return new DrawRectangle(operands);
        }
        if (operator.equals("v") || operator.equals("c") || operator.equals("y")) {
            return new DrawCurve(operator, operands);
        }
        if (operator.equals("EI")) {
            return EndInlineImage.Value;
        }
        if (operator.equals("BT")) {
            return BeginText.Value;
        }
        if (operator.equals("ET")) {
            return EndText.Value;
        }
        if (operator.equals("BMC") || operator.equals("BDC")) {
            return new BeginMarkedContent(operator, operands);
        }
        if (operator.equals("EMC")) {
            return EndMarkedContent.Value;
        }
        if (operator.equals("MP") || operator.equals("DP")) {
            return new MarkedContentPoint(operator, operands);
        }
        if (operator.equals("BI")) {
            return BeginInlineImage.Value;
        }
        if (operator.equals("EI")) {
            return EndInlineImage.Value;
        }
        if (operator.equals("gs")) {
            return new ApplyExtGState(operands);
        }
        return new GenericOperation(operator, operands);
    }

    protected Operation(String operator) {
        this.operator = operator;
    }

    protected Operation(String operator, PdfDirectObject operand) {
        this.operator = operator;
        this.operands = new ArrayList<PdfDirectObject>();
        this.operands.add(operand);
    }

    protected Operation(String operator, PdfDirectObject ... operands) {
        this.operator = operator;
        this.operands = new ArrayList<PdfDirectObject>();
        PdfDirectObject[] pdfDirectObjectArray = operands;
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            PdfDirectObject operand = pdfDirectObjectArray[n2];
            this.operands.add(operand);
            ++n2;
        }
    }

    protected Operation(String operator, List<PdfDirectObject> operands) {
        this.operator = operator;
        this.operands = operands;
    }

    public String getOperator() {
        return this.operator;
    }

    public List<PdfDirectObject> getOperands() {
        return this.operands;
    }

    public String toString() {
        return "{" + this.operator + " " + (this.operands == null ? "" : this.operands.toString()) + "}";
    }

    @Override
    public void writeTo(IOutputStream stream, Document context) {
        if (this.operands != null) {
            File fileContext = context.getFile();
            for (PdfDirectObject operand : this.operands) {
                operand.writeTo(stream, fileContext);
                stream.write(Chunk.Space);
            }
        }
        stream.write(this.operator);
        stream.write(Chunk.LineFeed);
    }
}

