/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.objects;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.fonts.Font;
import org.pdfclown.documents.contents.objects.Operation;
import org.pdfclown.documents.contents.objects.ShowTextToNextLine;
import org.pdfclown.objects.PdfDirectObject;

@PDF(value=VersionEnum.PDF10)
public abstract class ShowText
extends Operation {
    protected ShowText(String operator) {
        super(operator);
    }

    protected ShowText(String operator, PdfDirectObject ... operands) {
        super(operator, operands);
    }

    protected ShowText(String operator, List<PdfDirectObject> operands) {
        super(operator, operands);
    }

    public abstract byte[] getText();

    public List<Object> getValue() {
        return Arrays.asList(new Object[]{this.getText()});
    }

    @Override
    public void scan(ContentScanner.GraphicsState state) {
        this.scan(state, null);
    }

    public void scan(ContentScanner.GraphicsState state, IScanner textScanner) {
        AffineTransform tm;
        IContentContext context = state.getScanner().getContentContext();
        double contextHeight = context.getBox().getHeight();
        Font font = state.getFont();
        double fontSize = state.getFontSize();
        double scale = state.getScale() / 100.0;
        double scaledFactor = Font.getScalingFactor(fontSize) * scale;
        double wordSpace = state.getWordSpace() * scale;
        double charSpace = state.getCharSpace() * scale;
        AffineTransform ctm = (AffineTransform)state.getCtm().clone();
        if (this instanceof ShowTextToNextLine) {
            Double newCharSpace;
            ShowTextToNextLine showTextToNextLine = (ShowTextToNextLine)this;
            Double newWordSpace = showTextToNextLine.getWordSpace();
            if (newWordSpace != null) {
                if (textScanner == null) {
                    state.setWordSpace(newWordSpace);
                }
                wordSpace = newWordSpace * scale;
            }
            if ((newCharSpace = showTextToNextLine.getCharSpace()) != null) {
                if (textScanner == null) {
                    state.setCharSpace(newCharSpace);
                }
                charSpace = newCharSpace * scale;
            }
            tm = (AffineTransform)state.getTlm().clone();
            tm.translate(0.0, state.getLead());
        } else {
            tm = (AffineTransform)state.getTm().clone();
        }
        for (Object textElement : this.getValue()) {
            if (textElement instanceof byte[]) {
                String textString = font.decode((byte[])textElement);
                char[] cArray = textString.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char textChar = cArray[n2];
                    double charWidth = (double)font.getWidth(textChar) * scaledFactor;
                    if (textScanner != null) {
                        AffineTransform trm = (AffineTransform)ctm.clone();
                        trm.concatenate(tm);
                        double charHeight = font.getHeight(textChar, fontSize);
                        Rectangle2D.Double charBox = new Rectangle2D.Double(trm.getTranslateX(), contextHeight - trm.getTranslateY() - font.getAscent(fontSize) * trm.getScaleY(), charWidth * trm.getScaleX(), charHeight * trm.getScaleY());
                        textScanner.scanChar(textChar, charBox);
                    }
                    tm.translate(charWidth + charSpace + (textChar == ' ' ? wordSpace : 0.0), 0.0);
                    ++n2;
                }
                continue;
            }
            tm.translate(-((Number)textElement).doubleValue() * scaledFactor, 0.0);
        }
        if (textScanner == null) {
            state.setTm(tm);
            if (this instanceof ShowTextToNextLine) {
                state.setTlm((AffineTransform)tm.clone());
            }
        }
    }

    public abstract void setText(byte[] var1);

    public void setValue(List<Object> value) {
        this.setText((byte[])value.get(0));
    }

    public static interface IScanner {
        public void scanChar(char var1, Rectangle2D var2);
    }
}

