/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.xObjects;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.PropertyList;
import org.pdfclown.documents.contents.layers.ILayerable;
import org.pdfclown.documents.contents.layers.LayerEntity;
import org.pdfclown.documents.contents.xObjects.FormXObject;
import org.pdfclown.documents.contents.xObjects.ImageXObject;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfStream;

@PDF(value=VersionEnum.PDF10)
public abstract class XObject
extends PdfObjectWrapper<PdfStream>
implements ILayerable {
    public static XObject wrap(PdfDirectObject baseObject) {
        if (baseObject == null) {
            return null;
        }
        PdfName subtype = (PdfName)((PdfStream)baseObject.resolve()).getHeader().get(PdfName.Subtype);
        if (subtype.equals(PdfName.Form)) {
            return FormXObject.wrap(baseObject);
        }
        if (subtype.equals(PdfName.Image)) {
            return ImageXObject.wrap(baseObject);
        }
        return null;
    }

    protected XObject(Document context) {
        this(context, new PdfStream());
    }

    protected XObject(Document context, PdfStream baseDataObject) {
        super(context, baseDataObject);
        baseDataObject.getHeader().put(PdfName.Type, PdfName.XObject);
    }

    protected XObject(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public abstract AffineTransform getMatrix();

    public abstract Dimension2D getSize();

    public abstract void setMatrix(AffineTransform var1);

    public abstract void setSize(Dimension2D var1);

    @Override
    @PDF(value=VersionEnum.PDF15)
    public LayerEntity getLayer() {
        return (LayerEntity)PropertyList.wrap(((PdfStream)this.getBaseDataObject()).getHeader().get(PdfName.OC));
    }

    @Override
    public void setLayer(LayerEntity value) {
        ((PdfStream)this.getBaseDataObject()).getHeader().put(PdfName.OC, value.getBaseObject());
    }
}

