/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.Date;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.FileInputStream;
import org.pdfclown.bytes.IBuffer;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.documents.Document;
import org.pdfclown.objects.PdfDate;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfStream;

@PDF(value=VersionEnum.PDF13)
public final class EmbeddedFile
extends PdfObjectWrapper<PdfStream> {
    public static EmbeddedFile get(Document context, String path) {
        try {
            return new EmbeddedFile(context, new FileInputStream(new RandomAccessFile(path, "r")));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static EmbeddedFile get(Document context, File file) {
        return EmbeddedFile.get(context, file.getPath());
    }

    public static EmbeddedFile get(Document context, IInputStream stream) {
        return new EmbeddedFile(context, stream);
    }

    public static EmbeddedFile wrap(PdfDirectObject baseObject) {
        return baseObject != null ? new EmbeddedFile(baseObject) : null;
    }

    private EmbeddedFile(Document context, IInputStream stream) {
        super(context, new PdfStream(new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.EmbeddedFile}), new Buffer(stream.toByteArray())));
    }

    private EmbeddedFile(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public EmbeddedFile clone(Document context) {
        return (EmbeddedFile)super.clone(context);
    }

    public Date getCreationDate() {
        PdfDate dateObject = (PdfDate)this.getInfo(PdfName.CreationDate);
        return dateObject != null ? dateObject.getValue() : null;
    }

    public IBuffer getData() {
        return ((PdfStream)this.getBaseDataObject()).getBody();
    }

    public String getMimeType() {
        PdfName subtype = (PdfName)((PdfStream)this.getBaseDataObject()).getHeader().get(PdfName.Subtype);
        return subtype != null ? subtype.getValue() : null;
    }

    public Date getModificationDate() {
        PdfDate dateObject = (PdfDate)this.getInfo(PdfName.ModDate);
        return dateObject != null ? dateObject.getValue() : null;
    }

    public int getSize() {
        PdfInteger sizeObject = (PdfInteger)this.getInfo(PdfName.Size);
        return sizeObject != null ? sizeObject.getValue() : 0;
    }

    public void setCreationDate(Date value) {
        this.setInfo(PdfName.CreationDate, PdfDate.get(value));
    }

    public void setMimeType(String value) {
        ((PdfStream)this.getBaseDataObject()).getHeader().put(PdfName.Subtype, new PdfName(value));
    }

    public void setModificationDate(Date value) {
        this.setInfo(PdfName.ModDate, PdfDate.get(value));
    }

    public void setSize(int value) {
        this.setInfo(PdfName.Size, PdfInteger.get(value));
    }

    private PdfDirectObject getInfo(PdfName key) {
        return this.getParams().get(key);
    }

    private PdfDictionary getParams() {
        return ((PdfStream)this.getBaseDataObject()).getHeader().resolve(PdfName.Params, PdfDictionary.class);
    }

    private void setInfo(PdfName key, PdfDirectObject value) {
        this.getParams().put(key, value);
    }
}

