/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.files;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.bytes.OutputStream;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.files.EmbeddedFile;
import org.pdfclown.documents.files.FileSpecification;
import org.pdfclown.documents.files.RelatedFiles;
import org.pdfclown.files.FileIdentifier;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.objects.PdfString;
import org.pdfclown.objects.PdfTextString;

@PDF(value=VersionEnum.PDF11)
public final class FullFileSpecification
extends FileSpecification<PdfDictionary> {
    FullFileSpecification(Document context, String path) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.Filespec}));
        this.setPath(path);
    }

    FullFileSpecification(EmbeddedFile embeddedFile, String filename) {
        this(embeddedFile.getDocument(), filename);
        this.setEmbeddedFile(embeddedFile);
    }

    FullFileSpecification(Document context, URL url) {
        this(context, url.toString());
        this.setFileSystem((Object)StandardFileSystemEnum.URL);
    }

    FullFileSpecification(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public FullFileSpecification clone(Document context) {
        return (FullFileSpecification)super.clone(context);
    }

    public RelatedFiles getDependencies() {
        return this.getDependencies(PdfName.F);
    }

    public String getDescription() {
        return (String)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Desc));
    }

    public EmbeddedFile getEmbeddedFile() {
        return this.getEmbeddedFile(PdfName.F);
    }

    public Object getFileSystem() {
        PdfName fileSystemObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.FS);
        StandardFileSystemEnum standardFileSystem = StandardFileSystemEnum.valueOf(fileSystemObject);
        return standardFileSystem != null ? standardFileSystem : fileSystemObject.getValue();
    }

    public FileIdentifier getID() {
        return FileIdentifier.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.ID));
    }

    @Override
    public String getPath() {
        return this.getPath(PdfName.F);
    }

    @Override
    public IInputStream getInputStream() {
        if (PdfName.URL.equals(((PdfDictionary)this.getBaseDataObject()).get(PdfName.FS))) {
            URL fileUrl;
            try {
                fileUrl = new URL(this.getPath());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to instantiate URL for " + this.getPath(), e);
            }
            try {
                return new Buffer(fileUrl.openStream());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to open input stream for " + this.getPath(), e);
            }
        }
        return super.getInputStream();
    }

    @Override
    public IOutputStream getOutputStream() {
        if (PdfName.URL.equals(((PdfDictionary)this.getBaseDataObject()).get(PdfName.FS))) {
            URLConnection connection;
            URL fileUrl;
            try {
                fileUrl = new URL(this.getPath());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to instantiate URL for " + this.getPath(), e);
            }
            try {
                connection = fileUrl.openConnection();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to open connection for " + this.getPath(), e);
            }
            connection.setDoOutput(true);
            try {
                return new OutputStream(connection.getOutputStream());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to open output stream for " + this.getPath(), e);
            }
        }
        return super.getOutputStream();
    }

    public boolean isVolatile() {
        return (Boolean)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.V), false);
    }

    public void setDependencies(RelatedFiles value) {
        this.setDependencies(PdfName.F, value);
    }

    public void setDescription(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Desc, new PdfTextString(value));
    }

    public void setEmbeddedFile(EmbeddedFile value) {
        this.setEmbeddedFile(PdfName.F, value);
    }

    public void setFileSystem(Object value) {
        PdfName fileSystemObject;
        if (value instanceof StandardFileSystemEnum) {
            fileSystemObject = ((StandardFileSystemEnum)((Object)value)).getCode();
        } else if (value instanceof String) {
            fileSystemObject = new PdfName((String)value);
        } else {
            throw new IllegalArgumentException("MUST be either StandardFileSystemEnum (standard file system) or String (custom file system)");
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.FS, fileSystemObject);
    }

    public void setID(FileIdentifier value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.ID, value.getBaseObject());
    }

    public void setPath(String value) {
        this.setPath(PdfName.F, value);
    }

    public void setVolatile(boolean value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.V, PdfBoolean.get(value));
    }

    private RelatedFiles getDependencies(PdfName key) {
        PdfDictionary dependenciesObject = (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).get(PdfName.RF);
        if (dependenciesObject == null) {
            return null;
        }
        return RelatedFiles.wrap(dependenciesObject.get(key));
    }

    private EmbeddedFile getEmbeddedFile(PdfName key) {
        PdfDictionary embeddedFilesObject = (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).get(PdfName.EF);
        if (embeddedFilesObject == null) {
            return null;
        }
        return EmbeddedFile.wrap(embeddedFilesObject.get(key));
    }

    private String getPath(PdfName key) {
        return (String)PdfSimpleObject.getValue(((PdfDictionary)this.getBaseDataObject()).get(key));
    }

    private void setDependencies(PdfName key, RelatedFiles value) {
        PdfDictionary dependenciesObject = (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).get(PdfName.RF);
        if (dependenciesObject == null) {
            dependenciesObject = new PdfDictionary();
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.RF, dependenciesObject);
        }
        dependenciesObject.put(key, value.getBaseObject());
    }

    private void setEmbeddedFile(PdfName key, EmbeddedFile value) {
        PdfDictionary embeddedFilesObject = (PdfDictionary)((PdfDictionary)this.getBaseDataObject()).get(PdfName.EF);
        if (embeddedFilesObject == null) {
            embeddedFilesObject = new PdfDictionary();
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.EF, embeddedFilesObject);
        }
        embeddedFilesObject.put(key, value.getBaseObject());
    }

    private void setPath(PdfName key, String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(key, new PdfString(value));
    }

    public static enum StandardFileSystemEnum {
        Native(null),
        URL(PdfName.URL);

        private static Map<PdfName, StandardFileSystemEnum> map;
        private final PdfName code;

        static {
            map = new HashMap<PdfName, StandardFileSystemEnum>();
            StandardFileSystemEnum[] standardFileSystemEnumArray = StandardFileSystemEnum.values();
            int n = standardFileSystemEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                StandardFileSystemEnum value = standardFileSystemEnumArray[n2];
                map.put(value.getCode(), value);
                ++n2;
            }
        }

        private StandardFileSystemEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }

        public static StandardFileSystemEnum valueOf(String string) {
            return Enum.valueOf(StandardFileSystemEnum.class, string);
        }
    }
}

