/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF12)
public final class ChainedActions
extends PdfObjectWrapper<PdfDataObject>
implements List<Action> {
    private final Action parent;

    ChainedActions(PdfDirectObject baseObject, Action parent) {
        super(baseObject);
        this.parent = parent;
    }

    @Override
    public ChainedActions clone(Document context) {
        throw new NotImplementedException();
    }

    public Action getParent() {
        return this.parent;
    }

    @Override
    public void add(int index, Action value) {
        this.ensureArray().add(index, value.getBaseObject());
    }

    @Override
    public boolean addAll(int index, Collection<? extends Action> values) {
        for (Action action : values) {
            this.add(index++, action);
        }
        return true;
    }

    @Override
    public Action get(int index) {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
            }
            return Action.wrap(this.getBaseObject());
        }
        return Action.wrap(((PdfArray)baseDataObject).get(index));
    }

    @Override
    public int indexOf(Object value) {
        if (!(value instanceof Action)) {
            return -1;
        }
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            return ((Action)value).getBaseObject().equals(this.getBaseObject()) ? 0 : -1;
        }
        return ((PdfArray)baseDataObject).indexOf(((Action)value).getBaseObject());
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.indexOf(value);
    }

    @Override
    public ListIterator<Action> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<Action> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public Action remove(int index) {
        return Action.wrap(this.ensureArray().remove(index));
    }

    @Override
    public Action set(int index, Action value) {
        return Action.wrap(this.ensureArray().set(index, value.getBaseObject()));
    }

    @Override
    public List<Action> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException();
    }

    @Override
    public boolean add(Action value) {
        return this.ensureArray().add(value.getBaseObject());
    }

    @Override
    public boolean addAll(Collection<? extends Action> values) {
        for (Action action : values) {
            this.add(action);
        }
        return true;
    }

    @Override
    public void clear() {
        this.ensureArray().clear();
    }

    @Override
    public boolean contains(Object value) {
        if (!(value instanceof Action)) {
            return false;
        }
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            return ((Action)value).getBaseObject().equals(this.getBaseObject());
        }
        return ((PdfArray)baseDataObject).contains(((Action)value).getBaseObject());
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        throw new NotImplementedException();
    }

    @Override
    public boolean equals(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            return false;
        }
        return ((PdfArray)baseDataObject).isEmpty();
    }

    @Override
    public boolean remove(Object value) {
        if (!(value instanceof Action)) {
            return false;
        }
        return this.ensureArray().remove(((Action)value).getBaseObject());
    }

    @Override
    public boolean removeAll(Collection<?> values) {
        throw new NotImplementedException();
    }

    @Override
    public boolean retainAll(Collection<?> values) {
        throw new NotImplementedException();
    }

    @Override
    public int size() {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            return 1;
        }
        return ((PdfArray)baseDataObject).size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Action[0]);
    }

    @Override
    public <T> T[] toArray(T[] values) {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            if (values.length == 0) {
                values = new Object[]{Action.wrap(this.getBaseObject())};
            }
        } else {
            PdfArray actionObjects = (PdfArray)baseDataObject;
            if (values.length < actionObjects.size()) {
                values = new Object[actionObjects.size()];
            }
            int index = 0;
            int length = actionObjects.size();
            while (index < length) {
                values[index] = Action.wrap(actionObjects.get(index));
                ++index;
            }
        }
        return values;
    }

    @Override
    public Iterator<Action> iterator() {
        return new Iterator<Action>(){
            private int index = 0;
            private final int size;
            {
                this.size = ChainedActions.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Action next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ChainedActions.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private PdfArray ensureArray() {
        Object baseDataObject = this.getBaseDataObject();
        if (baseDataObject instanceof PdfDictionary) {
            PdfArray actionsArray = new PdfArray();
            actionsArray.add(this.getBaseObject());
            this.setBaseObject(actionsArray);
            ((PdfDictionary)this.parent.getBaseDataObject()).put(PdfName.Next, actionsArray);
            baseDataObject = actionsArray;
        }
        return (PdfArray)baseDataObject;
    }
}

