/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.actions;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.files.FileSpecification;
import org.pdfclown.documents.interaction.actions.GoToNonLocal;
import org.pdfclown.documents.interaction.navigation.document.Destination;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfSimpleObject;
import org.pdfclown.objects.PdfString;
import org.pdfclown.objects.PdfTextString;

@PDF(value=VersionEnum.PDF11)
public final class GoToEmbedded
extends GoToNonLocal<Destination> {
    public GoToEmbedded(Document context, PathElement destinationPath, Destination destination) {
        this(context, null, destinationPath, destination);
    }

    public GoToEmbedded(Document context, FileSpecification<?> destinationFile, Destination destination) {
        this(context, destinationFile, null, destination);
    }

    public GoToEmbedded(Document context, FileSpecification<?> destinationFile, PathElement destinationPath, Destination destination) {
        super(context, PdfName.GoToE, destinationFile, destination);
        this.setDestinationPath(destinationPath);
    }

    GoToEmbedded(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public GoToEmbedded clone(Document context) {
        return (GoToEmbedded)super.clone(context);
    }

    public PathElement getDestinationPath() {
        PdfDirectObject targetObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.T);
        return targetObject != null ? new PathElement(targetObject) : null;
    }

    public void setDestinationPath(PathElement value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.T);
        } else {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.T, value.getBaseObject());
        }
    }

    public static class PathElement
    extends PdfObjectWrapper<PdfDictionary> {
        public PathElement(Document context, PathElement next) {
            this(context, RelationEnum.Parent, null, null, null, next);
        }

        public PathElement(Document context, String embeddedFileName, PathElement next) {
            this(context, RelationEnum.Child, embeddedFileName, null, null, next);
        }

        public PathElement(Document context, Object annotationPageRef, Object annotationRef, PathElement next) {
            this(context, RelationEnum.Child, null, annotationPageRef, annotationRef, next);
        }

        private PathElement(Document context, RelationEnum relation, String embeddedFileName, Object annotationPageRef, Object annotationRef, PathElement next) {
            super(context, new PdfDictionary());
            this.setRelation(relation);
            this.setEmbeddedFileName(embeddedFileName);
            this.setAnnotationPageRef(annotationPageRef);
            this.setAnnotationRef(annotationRef);
            this.setNext(next);
        }

        private PathElement(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public PathElement clone(Document context) {
            return (PathElement)super.clone(context);
        }

        public Object getAnnotationPageRef() {
            PdfSimpleObject pageRefObject = (PdfSimpleObject)((PdfDictionary)this.getBaseDataObject()).get(PdfName.P);
            return pageRefObject != null ? pageRefObject.getValue() : null;
        }

        public Object getAnnotationRef() {
            PdfSimpleObject annotationRefObject = (PdfSimpleObject)((PdfDictionary)this.getBaseDataObject()).get(PdfName.A);
            return annotationRefObject != null ? annotationRefObject.getValue() : null;
        }

        public String getEmbeddedFileName() {
            PdfString fileNameObject = (PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.N);
            return fileNameObject != null ? (String)fileNameObject.getValue() : null;
        }

        public RelationEnum getRelation() {
            return RelationEnum.get((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.R));
        }

        public PathElement getNext() {
            PdfDirectObject targetObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.T);
            return targetObject != null ? new PathElement(targetObject) : null;
        }

        public void setAnnotationPageRef(Object value) {
            if (value == null) {
                ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.P);
            } else {
                PdfSimpleObject pageRefObject;
                if (value instanceof Integer) {
                    pageRefObject = PdfInteger.get((Integer)value);
                } else if (value instanceof String) {
                    pageRefObject = new PdfString((String)value);
                } else {
                    throw new IllegalArgumentException("Wrong argument type: it MUST be either a page number Integer or a named destination String.");
                }
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.P, pageRefObject);
            }
        }

        public void setAnnotationRef(Object value) {
            if (value == null) {
                ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.A);
            } else {
                PdfSimpleObject annotationRefObject;
                if (value instanceof Integer) {
                    annotationRefObject = PdfInteger.get((Integer)value);
                } else if (value instanceof String) {
                    annotationRefObject = PdfTextString.get((String)value);
                } else {
                    throw new IllegalArgumentException("Wrong argument type: it MUST be either an annotation index Integer or an annotation name String.");
                }
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.A, annotationRefObject);
            }
        }

        public void setEmbeddedFileName(String value) {
            if (value == null) {
                ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.N);
            } else {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.N, new PdfString(value));
            }
        }

        public void setRelation(RelationEnum value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.R, value.getCode());
        }

        public void setNext(PathElement value) {
            if (value == null) {
                ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.T);
            } else {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.T, value.getBaseObject());
            }
        }

        public static enum RelationEnum {
            Parent(PdfName.P),
            Child(PdfName.C);

            private final PdfName code;

            public static RelationEnum get(PdfName value) {
                RelationEnum[] relationEnumArray = RelationEnum.values();
                int n = relationEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RelationEnum relation = relationEnumArray[n2];
                    if (relation.getCode().equals(value)) {
                        return relation;
                    }
                    ++n2;
                }
                return null;
            }

            private RelationEnum(PdfName code) {
                this.code = code;
            }

            public PdfName getCode() {
                return this.code;
            }
        }
    }
}

