/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.layers.Layer;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF15)
public final class SetLayerState
extends Action {
    public SetLayerState(Document context) {
        super(context, PdfName.SetOCGState);
        this.setStates(new LayerStates());
    }

    SetLayerState(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public SetLayerState clone(Document context) {
        return (SetLayerState)super.clone(context);
    }

    public LayerStates getStates() {
        return new LayerStates(((PdfDictionary)this.getBaseDataObject()).get(PdfName.State));
    }

    public void setStates(LayerStates value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.State, value.getBaseObject());
    }

    public static class LayerState {
        private final Layers layers;
        private StateModeEnum mode;
        private LayerStates baseStates;

        public LayerState(StateModeEnum mode) {
            this(mode, new Layers(), null);
        }

        LayerState(StateModeEnum mode, Layers layers, LayerStates baseStates) {
            this.mode = mode;
            this.layers = layers;
            this.layers.parentState = this;
            this.attach(baseStates);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LayerState)) {
                return false;
            }
            LayerState state = (LayerState)obj;
            if (!state.getMode().equals((Object)this.getMode()) || state.getLayers().size() != this.getLayers().size()) {
                return false;
            }
            Iterator<Layer> layerIterator = this.getLayers().iterator();
            Iterator<Layer> stateLayerIterator = state.getLayers().iterator();
            while (layerIterator.hasNext()) {
                if (layerIterator.next().equals(stateLayerIterator.next())) continue;
                return false;
            }
            return true;
        }

        public List<Layer> getLayers() {
            return this.layers;
        }

        public StateModeEnum getMode() {
            return this.mode;
        }

        public int hashCode() {
            return this.mode.hashCode() ^ this.layers.size();
        }

        public void setMode(StateModeEnum value) {
            this.mode = value;
            if (this.baseStates != null) {
                int baseIndex = this.baseStates.getBaseIndex(this);
                ((PdfArray)this.baseStates.getBaseDataObject()).set(baseIndex, value.getName());
            }
        }

        void attach(LayerStates baseStates) {
            this.baseStates = baseStates;
        }

        void detach() {
            this.baseStates = null;
        }

        private static class Layers
        extends ArrayList<Layer> {
            private static final long serialVersionUID = 1L;
            private LayerState parentState;

            private Layers() {
            }

            @Override
            public boolean add(Layer item) {
                super.add(item);
                LayerStates baseStates = this.getBaseStates();
                if (baseStates != null) {
                    int baseIndex = baseStates.getBaseIndex(this.parentState);
                    int itemIndex = baseIndex + 1 + this.size() - 1;
                    ((PdfArray)baseStates.getBaseDataObject()).set(itemIndex, item.getBaseObject());
                }
                return true;
            }

            @Override
            public void add(int index, Layer item) {
                super.add(index, item);
                LayerStates baseStates = this.getBaseStates();
                if (baseStates != null) {
                    int baseIndex = baseStates.getBaseIndex(this.parentState);
                    int itemIndex = baseIndex + 1 + index;
                    ((PdfArray)baseStates.getBaseDataObject()).set(itemIndex, item.getBaseObject());
                }
            }

            @Override
            public boolean addAll(Collection<? extends Layer> items) {
                for (Layer layer : items) {
                    this.add(layer);
                }
                return !items.isEmpty();
            }

            @Override
            public boolean addAll(int index, Collection<? extends Layer> items) {
                for (Layer layer : items) {
                    this.add(index++, layer);
                }
                return !items.isEmpty();
            }

            @Override
            public void clear() {
                LayerStates baseStates = this.getBaseStates();
                if (baseStates != null) {
                    int itemIndex = baseStates.getBaseIndex(this.parentState) + 1;
                    int count = this.size();
                    while (count > 0) {
                        ((PdfArray)baseStates.getBaseDataObject()).remove(itemIndex);
                        --count;
                    }
                }
                super.clear();
            }

            @Override
            public boolean remove(Object item) {
                int index = this.indexOf(item);
                if (index == -1) {
                    return false;
                }
                this.remove(index);
                return true;
            }

            @Override
            public Layer remove(int index) {
                Layer layer = (Layer)super.remove(index);
                LayerStates baseStates = this.getBaseStates();
                if (baseStates != null) {
                    int baseIndex = baseStates.getBaseIndex(this.parentState);
                    int itemIndex = baseIndex + 1 + index;
                    ((PdfArray)baseStates.getBaseDataObject()).remove(itemIndex);
                }
                return layer;
            }

            @Override
            public boolean removeAll(Collection<?> items) {
                boolean changed = false;
                for (Object item : items) {
                    changed |= this.remove(item);
                }
                return changed;
            }

            @Override
            public boolean retainAll(Collection<?> items) {
                throw new NotImplementedException();
            }

            @Override
            public Layer set(int index, Layer item) {
                Layer oldLayer = this.remove(index);
                this.add(index, item);
                return oldLayer;
            }

            private LayerStates getBaseStates() {
                return this.parentState != null ? this.parentState.baseStates : null;
            }
        }
    }

    public static class LayerStates
    extends PdfObjectWrapper<PdfArray>
    implements List<LayerState> {
        private List<LayerState> items;

        public LayerStates() {
            super(new PdfArray());
        }

        LayerStates(PdfDirectObject baseObject) {
            super(baseObject);
            this.initialize();
        }

        @Override
        public LayerStates clone(Document context) {
            return (LayerStates)super.clone(context);
        }

        @Override
        public boolean add(LayerState item) {
            PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
            baseDataObject.add(item.getMode().getName());
            for (Layer layer : item.getLayers()) {
                baseDataObject.add(layer.getBaseObject());
            }
            this.items.add(item);
            item.attach(this);
            return true;
        }

        @Override
        public void add(int index, LayerState item) {
            int baseIndex = this.getBaseIndex(index);
            if (baseIndex == -1) {
                this.add(item);
            } else {
                PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
                baseDataObject.add(baseIndex++, item.getMode().getName());
                for (Layer layer : item.getLayers()) {
                    baseDataObject.add(baseIndex++, layer.getBaseObject());
                }
                this.items.add(index, item);
                item.attach(this);
            }
        }

        @Override
        public boolean addAll(Collection<? extends LayerState> items) {
            for (LayerState layerState : items) {
                this.add(layerState);
            }
            return !items.isEmpty();
        }

        @Override
        public boolean addAll(int index, Collection<? extends LayerState> items) {
            for (LayerState layerState : items) {
                this.add(index++, layerState);
            }
            return !items.isEmpty();
        }

        @Override
        public void clear() {
            ((PdfArray)this.getBaseDataObject()).clear();
            for (LayerState item : this.items) {
                item.detach();
            }
            this.items.clear();
        }

        @Override
        public boolean contains(Object item) {
            return this.items.contains(item);
        }

        @Override
        public boolean containsAll(Collection<?> items) {
            return this.items.containsAll(items);
        }

        @Override
        public LayerState get(int index) {
            return this.items.get(index);
        }

        @Override
        public int indexOf(Object item) {
            return this.items.indexOf(item);
        }

        @Override
        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        @Override
        public Iterator<LayerState> iterator() {
            return this.items.iterator();
        }

        @Override
        public int lastIndexOf(Object item) {
            return this.items.lastIndexOf(item);
        }

        @Override
        public ListIterator<LayerState> listIterator() {
            return this.items.listIterator();
        }

        @Override
        public ListIterator<LayerState> listIterator(int index) {
            return this.items.listIterator(index);
        }

        @Override
        public boolean remove(Object item) {
            int index = this.indexOf(item);
            if (index == -1) {
                return false;
            }
            this.remove(index);
            return true;
        }

        @Override
        public LayerState remove(int index) {
            int baseIndex = this.getBaseIndex(index);
            if (baseIndex == -1) {
                throw new IndexOutOfBoundsException();
            }
            PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
            boolean done = false;
            int baseCount = baseDataObject.size();
            while (baseIndex < baseCount) {
                if (baseDataObject.get(baseIndex) instanceof PdfName) {
                    if (done) break;
                    done = true;
                }
                baseDataObject.remove(baseIndex);
            }
            LayerState layerState = this.items.remove(index);
            layerState.detach();
            return layerState;
        }

        @Override
        public boolean removeAll(Collection<?> items) {
            boolean changed = false;
            for (Object item : items) {
                if (!this.remove(item)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> items) {
            throw new NotImplementedException();
        }

        @Override
        public LayerState set(int index, LayerState item) {
            LayerState oldLayerState = this.remove(index);
            this.add(index, item);
            return oldLayerState;
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public List<LayerState> subList(int fromIndex, int toIndex) {
            throw new NotImplementedException();
        }

        @Override
        public Object[] toArray() {
            throw new NotImplementedException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new NotImplementedException();
        }

        private int getBaseIndex(int index) {
            int baseIndex = -1;
            PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
            int layerStateIndex = -1;
            int baseItemIndex = 0;
            int baseItemCount = baseDataObject.size();
            while (baseItemIndex < baseItemCount) {
                if (baseDataObject.get(baseItemIndex) instanceof PdfName && ++layerStateIndex == index) {
                    baseIndex = baseItemIndex;
                    break;
                }
                ++baseItemIndex;
            }
            return baseIndex;
        }

        private int getBaseIndex(LayerState item) {
            int baseIndex = -1;
            PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
            int baseItemIndex = 0;
            int baseItemCount = baseDataObject.size();
            while (baseItemIndex < baseItemCount) {
                PdfDirectObject baseItem = baseDataObject.get(baseItemIndex);
                if (baseItem instanceof PdfName && baseItem.equals(item.getMode().getName())) {
                    for (Layer layer : item.getLayers()) {
                        if (++baseItemIndex >= baseItemCount || (baseItem = baseDataObject.get(baseItemIndex)) instanceof PdfName || !baseItem.equals(layer.getBaseObject())) break;
                    }
                }
                ++baseItemIndex;
            }
            return baseIndex;
        }

        private void initialize() {
            this.items = new ArrayList<LayerState>();
            PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
            StateModeEnum mode = null;
            LayerState.Layers layers = null;
            int baseIndex = 0;
            int baseCount = baseDataObject.size();
            while (baseIndex < baseCount) {
                PdfDirectObject baseObject = baseDataObject.get(baseIndex);
                if (baseObject instanceof PdfName) {
                    if (mode != null) {
                        this.items.add(new LayerState(mode, layers, this));
                    }
                    mode = StateModeEnum.valueOf((PdfName)baseObject);
                    layers = new LayerState.Layers();
                } else {
                    layers.add(Layer.wrap(baseObject));
                }
                ++baseIndex;
            }
            if (mode != null) {
                this.items.add(new LayerState(mode, layers, this));
            }
        }
    }

    public static enum StateModeEnum {
        On(PdfName.ON),
        Off(PdfName.OFF),
        Toggle(PdfName.Toggle);

        private PdfName name;

        private StateModeEnum(PdfName name) {
            this.name = name;
        }

        public PdfName getName() {
            return this.name;
        }

        public static StateModeEnum valueOf(String string) {
            return Enum.valueOf(StateModeEnum.class, string);
        }
    }
}

