/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF12)
public class AnnotationActions
extends PdfObjectWrapper<PdfDictionary>
implements Map<PdfName, Action> {
    private final Annotation parent;

    public AnnotationActions(Annotation parent) {
        super(parent.getDocument(), new PdfDictionary());
        this.parent = parent;
    }

    AnnotationActions(Annotation parent, PdfDirectObject baseObject) {
        super(baseObject);
        this.parent = parent;
    }

    @Override
    public AnnotationActions clone(Document context) {
        throw new NotImplementedException();
    }

    public Action getOnActivate() {
        return this.parent.getAction();
    }

    public Action getOnEnter() {
        return this.get(PdfName.E);
    }

    public Action getOnExit() {
        return this.get(PdfName.X);
    }

    public Action getOnMouseDown() {
        return this.get(PdfName.D);
    }

    public Action getOnMouseUp() {
        return this.get(PdfName.U);
    }

    public Action getOnPageClose() {
        return this.get(PdfName.PC);
    }

    public Action getOnPageInvisible() {
        return this.get(PdfName.PI);
    }

    public Action getOnPageOpen() {
        return this.get(PdfName.PO);
    }

    public Action getOnPageVisible() {
        return this.get(PdfName.PV);
    }

    public void setOnActivate(Action value) {
        this.parent.setAction(value);
    }

    public void setOnEnter(Action value) {
        this.put(PdfName.E, value);
    }

    public void setOnExit(Action value) {
        this.put(PdfName.X, value);
    }

    public void setOnMouseDown(Action value) {
        this.put(PdfName.D, value);
    }

    public void setOnMouseUp(Action value) {
        this.put(PdfName.U, value);
    }

    public void setOnPageClose(Action value) {
        this.put(PdfName.PC, value);
    }

    public void setOnPageInvisible(Action value) {
        this.put(PdfName.PI, value);
    }

    public void setOnPageOpen(Action value) {
        this.put(PdfName.PO, value);
    }

    public void setOnPageVisible(Action value) {
        this.put(PdfName.PV, value);
    }

    @Override
    public void clear() {
        ((PdfDictionary)this.getBaseDataObject()).clear();
        this.setOnActivate(null);
    }

    @Override
    public boolean containsKey(Object key) {
        return ((PdfDictionary)this.getBaseDataObject()).containsKey(key) || PdfName.A.equals(key) && ((PdfDictionary)this.parent.getBaseDataObject()).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return value != null && (((PdfDictionary)this.getBaseDataObject()).containsValue(((Action)value).getBaseObject()) || value.equals(this.getOnActivate()));
    }

    @Override
    public Set<Map.Entry<PdfName, Action>> entrySet() {
        throw new NotImplementedException();
    }

    @Override
    public Action get(Object key) {
        return Action.wrap(((PdfDictionary)this.getBaseDataObject()).get(key));
    }

    @Override
    public boolean isEmpty() {
        return ((PdfDictionary)this.getBaseDataObject()).isEmpty() && this.getOnActivate() == null;
    }

    @Override
    public Set<PdfName> keySet() {
        HashSet<PdfName> keySet = new HashSet<PdfName>(((PdfDictionary)this.getBaseDataObject()).keySet());
        if (((PdfDictionary)this.parent.getBaseDataObject()).containsKey(PdfName.A)) {
            keySet.add(PdfName.A);
        }
        return this.keySet();
    }

    @Override
    public Action put(PdfName key, Action value) {
        return Action.wrap(((PdfDictionary)this.getBaseDataObject()).put(key, value != null ? value.getBaseObject() : null));
    }

    @Override
    public void putAll(Map<? extends PdfName, ? extends Action> entries) {
        throw new NotImplementedException();
    }

    @Override
    public Action remove(Object key) {
        Action oldValue;
        if (PdfName.A.equals(key) && ((PdfDictionary)this.parent.getBaseDataObject()).containsKey(key)) {
            oldValue = this.getOnActivate();
            this.setOnActivate(null);
        } else {
            oldValue = Action.wrap(((PdfDictionary)this.getBaseDataObject()).remove(key));
        }
        return oldValue;
    }

    @Override
    public int size() {
        return ((PdfDictionary)this.getBaseDataObject()).size() + (((PdfDictionary)this.parent.getBaseDataObject()).containsKey(PdfName.A) ? 1 : 0);
    }

    @Override
    public Collection<Action> values() {
        Collection<PdfDirectObject> objects = ((PdfDictionary)this.getBaseDataObject()).values();
        ArrayList<Action> values = new ArrayList<Action>(objects.size());
        for (PdfDirectObject object : objects) {
            values.add(Action.wrap(object));
        }
        Action action = this.getOnActivate();
        if (action != null) {
            values.add(action);
        }
        return values;
    }
}

