/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.interaction.JustificationEnum;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF13)
public final class CalloutNote
extends Annotation {
    public CalloutNote(Page page, Rectangle2D box, String text) {
        super(page, PdfName.FreeText, box, text);
    }

    CalloutNote(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public CalloutNote clone(Document context) {
        return (CalloutNote)super.clone(context);
    }

    public JustificationEnum getJustification() {
        return JustificationEnum.valueOf((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Q));
    }

    public LineObject getLine() {
        PdfArray calloutLineObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.CL);
        return calloutLineObject != null ? new LineObject(calloutLineObject) : null;
    }

    public void setJustification(JustificationEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Q, value.getCode());
    }

    public void setLine(LineObject value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.CL, value.getBaseObject());
    }

    public static class LineObject
    extends PdfObjectWrapper<PdfArray> {
        private Page page;

        public LineObject(Page page, Point2D start, Point2D end) {
            this(page, start, null, end);
        }

        public LineObject(Page page, Point2D start, Point2D knee, Point2D end) {
            super(page.getDocument(), new PdfArray());
            this.page = page;
            PdfArray baseDataObject = (PdfArray)this.getBaseDataObject();
            double pageHeight = page.getBox().getHeight();
            baseDataObject.add(PdfReal.get(start.getX()));
            baseDataObject.add(PdfReal.get(pageHeight - start.getY()));
            if (knee != null) {
                baseDataObject.add(PdfReal.get(knee.getX()));
                baseDataObject.add(PdfReal.get(pageHeight - knee.getY()));
            }
            baseDataObject.add(PdfReal.get(end.getX()));
            baseDataObject.add(PdfReal.get(pageHeight - end.getY()));
        }

        private LineObject(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public LineObject clone(Document context) {
            return (LineObject)super.clone(context);
        }

        public Point2D getEnd() {
            PdfArray coordinates = (PdfArray)this.getBaseDataObject();
            if (coordinates.size() < 6) {
                return new Point2D.Double(((PdfNumber)coordinates.get(2)).getDoubleValue(), this.page.getBox().getHeight() - ((PdfNumber)coordinates.get(3)).getDoubleValue());
            }
            return new Point2D.Double(((PdfNumber)coordinates.get(4)).getDoubleValue(), this.page.getBox().getHeight() - ((PdfNumber)coordinates.get(5)).getDoubleValue());
        }

        public Point2D getKnee() {
            PdfArray coordinates = (PdfArray)this.getBaseDataObject();
            if (coordinates.size() < 6) {
                return null;
            }
            return new Point2D.Double(((PdfNumber)coordinates.get(2)).getDoubleValue(), this.page.getBox().getHeight() - ((PdfNumber)coordinates.get(3)).getDoubleValue());
        }

        public Point2D getStart() {
            PdfArray coordinates = (PdfArray)this.getBaseDataObject();
            return new Point2D.Double(((PdfNumber)coordinates.get(0)).getDoubleValue(), this.page.getBox().getHeight() - ((PdfNumber)coordinates.get(1)).getDoubleValue());
        }
    }
}

