/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.geom.Rectangle2D;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.files.FileSpecification;
import org.pdfclown.documents.files.IFileResource;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;

@PDF(value=VersionEnum.PDF13)
public final class FileAttachment
extends Annotation
implements IFileResource {
    public FileAttachment(Page page, Rectangle2D box, String text, FileSpecification<?> dataFile) {
        super(page, PdfName.FileAttachment, box, text);
        this.setDataFile(dataFile);
    }

    FileAttachment(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public FileAttachment clone(Document context) {
        return (FileAttachment)super.clone(context);
    }

    public IconTypeEnum getIconType() {
        PdfName nameObject = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Name);
        return nameObject != null ? IconTypeEnum.get(nameObject) : IconTypeEnum.PushPin;
    }

    public void setIconType(IconTypeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Name, value.getCode());
    }

    @Override
    public FileSpecification<?> getDataFile() {
        return FileSpecification.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.FS));
    }

    @Override
    public void setDataFile(FileSpecification<?> value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.FS, value.getBaseObject());
    }

    public static enum IconTypeEnum {
        Graph(PdfName.Graph),
        PaperClip(PdfName.Paperclip),
        PushPin(PdfName.PushPin),
        Tag(PdfName.Tag);

        private final PdfName code;

        public static IconTypeEnum get(PdfName value) {
            IconTypeEnum[] iconTypeEnumArray = IconTypeEnum.values();
            int n = iconTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconTypeEnum iconType = iconTypeEnumArray[n2];
                if (iconType.getCode().equals(value)) {
                    return iconType;
                }
                ++n2;
            }
            return null;
        }

        private IconTypeEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

