/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.annotations;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF13)
public final class Scribble
extends Annotation {
    public Scribble(Page page, Rectangle2D box, String text, List<List<Point2D>> paths) {
        super(page, PdfName.Ink, box, text);
        this.setPaths(paths);
    }

    Scribble(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Scribble clone(Document context) {
        return (Scribble)super.clone(context);
    }

    public List<List<Point2D>> getPaths() {
        PdfArray pathsObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.InkList);
        ArrayList<List<Point2D>> paths = new ArrayList<List<Point2D>>();
        double pageHeight = this.getPage().getBox().getHeight();
        int pathIndex = 0;
        int pathLength = pathsObject.size();
        while (pathIndex < pathLength) {
            PdfArray pathObject = (PdfArray)pathsObject.get(pathIndex);
            ArrayList<Point2D.Double> path = new ArrayList<Point2D.Double>();
            int pointIndex = 0;
            int pointLength = pathObject.size();
            while (pointIndex < pointLength) {
                path.add(new Point2D.Double(((PdfNumber)pathObject.get(pointIndex)).getDoubleValue(), pageHeight - ((PdfNumber)pathObject.get(pointIndex + 1)).getDoubleValue()));
                pointIndex += 2;
            }
            paths.add(path);
            ++pathIndex;
        }
        return paths;
    }

    public void setPaths(List<List<Point2D>> value) {
        PdfArray pathsObject = new PdfArray();
        double pageHeight = this.getPage().getBox().getHeight();
        for (List<Point2D> path : value) {
            PdfArray pathObject = new PdfArray();
            for (Point2D point : path) {
                pathObject.add(PdfReal.get(point.getX()));
                pathObject.add(PdfReal.get(pageHeight - point.getY()));
            }
            pathsObject.add(pathObject);
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.InkList, pathsObject);
    }
}

