/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.forms;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interaction.annotations.Widget;
import org.pdfclown.documents.interaction.forms.ButtonField;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;

@PDF(value=VersionEnum.PDF12)
public final class CheckBox
extends ButtonField {
    public CheckBox(String name, Widget widget, boolean checked) {
        super(name, widget);
        this.setChecked(checked);
    }

    CheckBox(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public CheckBox clone(Document context) {
        return (CheckBox)super.clone(context);
    }

    public boolean isChecked() {
        PdfName value = (PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.V);
        return value != null && !value.equals(PdfName.Off);
    }

    public void setChecked(boolean value) {
        PdfDictionary widgetDictionary = (PdfDictionary)this.getWidgets().get(0).getBaseDataObject();
        PdfName baseValue = null;
        if (value) {
            PdfDictionary appearanceDictionary = (PdfDictionary)widgetDictionary.resolve(PdfName.AP);
            if (appearanceDictionary != null) {
                for (PdfName appearanceKey : ((PdfDictionary)appearanceDictionary.resolve(PdfName.N)).keySet()) {
                    if (appearanceKey.equals(PdfName.Off)) continue;
                    baseValue = appearanceKey;
                    break;
                }
            } else {
                baseValue = PdfName.Yes;
            }
        } else {
            baseValue = PdfName.Off;
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.V, baseValue);
        widgetDictionary.put(PdfName.AS, baseValue);
    }

    @Override
    public void setValue(Object value) {
        this.setChecked(value != null && !value.equals("") && !value.equals(PdfName.Off.getValue()));
    }
}

