/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.forms;

import java.awt.geom.Rectangle2D;
import java.util.EnumSet;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.FontResources;
import org.pdfclown.documents.contents.composition.BlockComposer;
import org.pdfclown.documents.contents.composition.PrimitiveComposer;
import org.pdfclown.documents.contents.composition.XAlignmentEnum;
import org.pdfclown.documents.contents.composition.YAlignmentEnum;
import org.pdfclown.documents.contents.fonts.Font;
import org.pdfclown.documents.contents.fonts.StandardType1Font;
import org.pdfclown.documents.contents.objects.ContentObject;
import org.pdfclown.documents.contents.objects.MarkedContent;
import org.pdfclown.documents.contents.objects.SetFont;
import org.pdfclown.documents.contents.objects.Text;
import org.pdfclown.documents.contents.tokens.ContentParser;
import org.pdfclown.documents.contents.xObjects.FormXObject;
import org.pdfclown.documents.interaction.JustificationEnum;
import org.pdfclown.documents.interaction.annotations.AppearanceStates;
import org.pdfclown.documents.interaction.annotations.Widget;
import org.pdfclown.documents.interaction.forms.Field;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfString;
import org.pdfclown.objects.PdfTextString;
import org.pdfclown.util.EnumUtils;
import org.pdfclown.util.math.geom.Dimension;

@PDF(value=VersionEnum.PDF12)
public final class TextField
extends Field {
    public TextField(String name, Widget widget, String value) {
        super(PdfName.Tx, name, widget);
        this.setValue(value);
    }

    TextField(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public TextField clone(Document context) {
        return (TextField)super.clone(context);
    }

    public JustificationEnum getJustification() {
        return JustificationEnum.valueOf((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Q));
    }

    public int getMaxLength() {
        PdfInteger maxLengthObject = (PdfInteger)PdfObject.resolve(this.getInheritableAttribute(PdfName.MaxLen));
        return maxLengthObject != null ? maxLengthObject.getValue() : Integer.MAX_VALUE;
    }

    public boolean isMultiline() {
        return this.getFlags().contains((Object)Field.FlagsEnum.Multiline);
    }

    public boolean isPassword() {
        return this.getFlags().contains((Object)Field.FlagsEnum.Password);
    }

    public boolean isSpellChecked() {
        return !this.getFlags().contains((Object)Field.FlagsEnum.DoNotSpellCheck);
    }

    public void setJustification(JustificationEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Q, value.getCode());
    }

    public void setMaxLength(int value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.MaxLen, value != Integer.MAX_VALUE ? PdfInteger.get(value) : null);
    }

    public void setMultiline(boolean value) {
        this.setFlags(EnumUtils.mask(this.getFlags(), Field.FlagsEnum.Multiline, value));
    }

    public void setPassword(boolean value) {
        this.setFlags(EnumUtils.mask(this.getFlags(), Field.FlagsEnum.Password, value));
    }

    public void setSpellChecked(boolean value) {
        this.setFlags(EnumUtils.mask(this.getFlags(), Field.FlagsEnum.DoNotSpellCheck, !value));
    }

    @Override
    public void setValue(Object value) {
        String stringValue = (String)value;
        if (stringValue != null) {
            int maxLength = this.getMaxLength();
            if (stringValue.length() > maxLength) {
                stringValue = stringValue.substring(0, maxLength);
            }
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.V, new PdfTextString((String)value));
        this.refreshAppearance();
    }

    private void refreshAppearance() {
        Widget widget = this.getWidgets().get(0);
        AppearanceStates normalAppearances = widget.getAppearance().getNormal();
        FormXObject normalAppearance = normalAppearances.get(null);
        if (normalAppearance == null) {
            normalAppearance = new FormXObject(this.getDocument(), Dimension.get(widget.getBox()));
            normalAppearances.put(null, normalAppearance);
        }
        PdfName fontName = null;
        double fontSize = 0.0;
        PdfString defaultAppearanceState = this.getDefaultAppearanceState();
        if (defaultAppearanceState == null) {
            Font defaultFont = null;
            PdfName defaultFontName = null;
            FontResources normalAppearanceFonts = normalAppearance.getResources().getFonts();
            for (Map.Entry entry : normalAppearanceFonts.entrySet()) {
                if (((Font)entry.getValue()).isSymbolic()) continue;
                defaultFont = (Font)entry.getValue();
                defaultFontName = entry.getKey();
                break;
            }
            if (defaultFontName == null) {
                FontResources formFonts = this.getDocument().getForm().getResources().getFonts();
                for (Map.Entry entry : formFonts.entrySet()) {
                    if (((Font)entry.getValue()).isSymbolic()) continue;
                    defaultFont = (Font)entry.getValue();
                    defaultFontName = entry.getKey();
                    break;
                }
                if (defaultFontName == null) {
                    defaultFontName = new PdfName("default");
                    defaultFont = new StandardType1Font(this.getDocument(), StandardType1Font.FamilyEnum.Helvetica, false, false);
                    formFonts.put(defaultFontName, defaultFont);
                }
                normalAppearanceFonts.put(defaultFontName, defaultFont);
            }
            Buffer buffer = new Buffer();
            new SetFont(defaultFontName, this.isMultiline() ? 10 : 0).writeTo(buffer, this.getDocument());
            defaultAppearanceState = new PdfString(buffer.toByteArray());
            ((PdfDictionary)widget.getBaseDataObject()).put(PdfName.DA, defaultAppearanceState);
        }
        ContentParser parser = new ContentParser(defaultAppearanceState.toByteArray());
        for (ContentObject content : parser.parseContentObjects()) {
            if (!(content instanceof SetFont)) continue;
            SetFont setFontOperation = (SetFont)content;
            fontName = setFontOperation.getName();
            fontSize = setFontOperation.getSize();
            break;
        }
        normalAppearance.getResources().getFonts().put(fontName, (Font)this.getDocument().getForm().getResources().getFonts().get(fontName));
        PrimitiveComposer baseComposer = new PrimitiveComposer(normalAppearance);
        BlockComposer composer = new BlockComposer(baseComposer);
        ContentScanner currentLevel = composer.getScanner();
        boolean textShown = false;
        while (currentLevel != null) {
            if (!currentLevel.moveNext()) {
                currentLevel = currentLevel.getParentLevel();
                continue;
            }
            ContentObject content = currentLevel.getCurrent();
            if (content instanceof MarkedContent) {
                MarkedContent markedContent = (MarkedContent)content;
                if (!PdfName.Tx.equals(markedContent.getHeader().getTag())) continue;
                markedContent.getObjects().clear();
                baseComposer.setScanner(currentLevel.getChildLevel());
                this.showText(composer, fontName, fontSize);
                textShown = true;
                continue;
            }
            if (content instanceof Text) {
                currentLevel.remove();
                continue;
            }
            if (currentLevel.getChildLevel() == null) continue;
            currentLevel = currentLevel.getChildLevel();
        }
        if (!textShown) {
            baseComposer.beginMarkedContent(PdfName.Tx);
            this.showText(composer, fontName, fontSize);
            baseComposer.end();
        }
        baseComposer.flush();
    }

    private void showText(BlockComposer composer, PdfName fontName, double fontSize) {
        YAlignmentEnum yAlignment;
        int maxLength;
        PrimitiveComposer baseComposer = composer.getBaseComposer();
        ContentScanner scanner = baseComposer.getScanner();
        Rectangle2D textBox = scanner.getContentContext().getBox();
        if (scanner.getState().getFont() == null) {
            if (fontSize == 0.0) {
                fontSize = textBox.getHeight() * 0.65;
            }
            baseComposer.setFont(fontName, fontSize);
        }
        String text = (String)this.getValue();
        EnumSet<Field.FlagsEnum> flags = this.getFlags();
        if (flags.contains((Object)Field.FlagsEnum.Comb) && !flags.contains((Object)Field.FlagsEnum.FileSelect) && !flags.contains((Object)Field.FlagsEnum.Multiline) && !flags.contains((Object)Field.FlagsEnum.Password) && (maxLength = this.getMaxLength()) > 0) {
            textBox.setRect(textBox.getX(), textBox.getY(), textBox.getWidth() / (double)maxLength, textBox.getHeight());
            int index = 0;
            int length = text.length();
            while (index < length) {
                composer.begin(textBox, XAlignmentEnum.Center, YAlignmentEnum.Middle);
                composer.showText(Character.toString(text.charAt(index)));
                composer.end();
                textBox.setRect(textBox.getX() + textBox.getWidth(), textBox.getY(), textBox.getWidth(), textBox.getHeight());
                ++index;
            }
            return;
        }
        textBox.setRect(textBox.getX() + 2.0, textBox.getY(), textBox.getWidth() - 4.0, textBox.getHeight());
        if (flags.contains((Object)Field.FlagsEnum.Multiline)) {
            yAlignment = YAlignmentEnum.Top;
            textBox.setRect(textBox.getX(), textBox.getY() + fontSize * 0.35, textBox.getWidth(), textBox.getHeight() - fontSize * 0.7);
        } else {
            yAlignment = YAlignmentEnum.Middle;
        }
        composer.begin(textBox, this.getJustification().toXAlignment(), yAlignment);
        composer.showText(text);
        composer.end();
    }
}

