/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.interaction.navigation.document;

import java.util.EnumSet;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.colorSpaces.DeviceRGBColor;
import org.pdfclown.documents.interaction.ILink;
import org.pdfclown.documents.interaction.actions.Action;
import org.pdfclown.documents.interaction.navigation.document.Bookmarks;
import org.pdfclown.documents.interaction.navigation.document.Destination;
import org.pdfclown.documents.interaction.navigation.document.LocalDestination;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfTextString;

@PDF(value=VersionEnum.PDF10)
public final class Bookmark
extends PdfObjectWrapper<PdfDictionary>
implements ILink {
    public Bookmark(Document context, String title) {
        super(context, new PdfDictionary());
        this.setTitle(title);
    }

    public Bookmark(Document context, String title, LocalDestination destination) {
        this(context, title);
        this.setDestination(destination);
    }

    public Bookmark(Document context, String title, Action action) {
        this(context, title);
        this.setAction(action);
    }

    Bookmark(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Bookmark clone(Document context) {
        return (Bookmark)super.clone(context);
    }

    public Bookmarks getBookmarks() {
        return Bookmarks.wrap(this.getBaseObject());
    }

    @PDF(value=VersionEnum.PDF14)
    public DeviceRGBColor getColor() {
        return DeviceRGBColor.get((PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.C));
    }

    @PDF(value=VersionEnum.PDF14)
    public EnumSet<FlagsEnum> getFlags() {
        PdfInteger flagsObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.F);
        if (flagsObject == null) {
            return EnumSet.noneOf(FlagsEnum.class);
        }
        return FlagsEnum.toEnumSet((Integer)flagsObject.getRawValue());
    }

    public Bookmark getParent() {
        PdfReference reference = (PdfReference)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Parent);
        if (((PdfDictionary)reference.getDataObject()).containsKey(PdfName.Title)) {
            return new Bookmark(reference);
        }
        return null;
    }

    public String getTitle() {
        return ((PdfTextString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Title)).getValue();
    }

    public boolean isExpanded() {
        PdfInteger countObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Count);
        return countObject == null || (Integer)countObject.getRawValue() >= 0;
    }

    public void setColor(DeviceRGBColor value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.C);
        } else {
            this.checkCompatibility("color");
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.C, value.getBaseObject());
        }
    }

    public void setExpanded(boolean value) {
        PdfInteger countObject = (PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Count);
        if (countObject == null) {
            return;
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Count, PdfInteger.get((value ? 1 : -1) * Math.abs(countObject.getValue())));
    }

    public void setFlags(EnumSet<FlagsEnum> value) {
        if (value.isEmpty()) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.F);
        } else {
            this.checkCompatibility(value);
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.F, PdfInteger.get(FlagsEnum.toInt(value)));
        }
    }

    public void setTitle(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Title, new PdfTextString(value));
    }

    @Override
    public PdfObjectWrapper<?> getTarget() {
        if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.Dest)) {
            return this.getDestination();
        }
        if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.A)) {
            return this.getAction();
        }
        return null;
    }

    @Override
    public void setTarget(PdfObjectWrapper<?> value) {
        if (value instanceof Destination) {
            this.setDestination((Destination)value);
        } else if (value instanceof Action) {
            this.setAction((Action)value);
        } else {
            throw new IllegalArgumentException("It MUST be either a Destination or an Action.");
        }
    }

    private Action getAction() {
        return Action.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.A));
    }

    private Destination getDestination() {
        PdfDirectObject destinationObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.Dest);
        return destinationObject != null ? this.getDocument().resolveName(LocalDestination.class, destinationObject) : null;
    }

    private void setAction(Action value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.A);
        } else {
            if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.Dest)) {
                ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Dest);
            }
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.A, value.getBaseObject());
        }
    }

    private void setDestination(Destination value) {
        if (value == null) {
            ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.Dest);
        } else {
            if (((PdfDictionary)this.getBaseDataObject()).containsKey(PdfName.A)) {
                ((PdfDictionary)this.getBaseDataObject()).remove(PdfName.A);
            }
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Dest, value.getNamedBaseObject());
        }
    }

    @PDF(value=VersionEnum.PDF14)
    public static enum FlagsEnum {
        Italic(1),
        Bold(2);

        private final int code;

        public static int toInt(EnumSet<FlagsEnum> flags) {
            int flagsMask = 0;
            for (FlagsEnum flag : flags) {
                flagsMask |= flag.getCode();
            }
            return flagsMask;
        }

        public static EnumSet<FlagsEnum> toEnumSet(int flagsMask) {
            EnumSet<FlagsEnum> flags = EnumSet.noneOf(FlagsEnum.class);
            FlagsEnum[] flagsEnumArray = FlagsEnum.values();
            int n = flagsEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                FlagsEnum flag = flagsEnumArray[n2];
                if ((flagsMask & flag.getCode()) > 0) {
                    flags.add(flag);
                }
                ++n2;
            }
            return flags;
        }

        private FlagsEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

