/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.multimedia;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.xObjects.FormXObject;
import org.pdfclown.documents.files.FileSpecification;
import org.pdfclown.documents.multimedia.MediaClip;
import org.pdfclown.documents.multimedia.MediaPlayers;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.objects.PdfString;

@PDF(value=VersionEnum.PDF15)
public final class MediaClipData
extends MediaClip {
    public MediaClipData(PdfObjectWrapper<?> data, String mimeType) {
        super(data.getDocument(), PdfName.MCD);
        this.setData(data);
        this.setMimeType(mimeType);
        this.setTempFilePermission(TempFilePermissionEnum.Always);
    }

    MediaClipData(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public MediaClipData clone(Document context) {
        return (MediaClipData)super.clone(context);
    }

    @Override
    public PdfObjectWrapper<?> getData() {
        PdfDirectObject dataObject = ((PdfDictionary)this.getBaseDataObject()).get(PdfName.D);
        if (dataObject == null) {
            return null;
        }
        if (dataObject.resolve() instanceof PdfStream) {
            return FormXObject.wrap(dataObject);
        }
        return FileSpecification.wrap(dataObject);
    }

    public String getMimeType() {
        return (String)PdfString.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.CT));
    }

    public MediaPlayers getPlayers() {
        return MediaPlayers.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.PL, PdfDictionary.class));
    }

    public Viability getPreferences() {
        return new Viability(((PdfDictionary)this.getBaseDataObject()).get(PdfName.BE, PdfDictionary.class));
    }

    public Viability getRequirements() {
        return new Viability(((PdfDictionary)this.getBaseDataObject()).get(PdfName.MH, PdfDictionary.class));
    }

    public TempFilePermissionEnum getTempFilePermission() {
        return TempFilePermissionEnum.valueOf((PdfString)((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.P, PdfDictionary.class).get(PdfName.TF));
    }

    public void setData(PdfObjectWrapper<?> value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.D, PdfObjectWrapper.getBaseObject(value));
    }

    public void setMimeType(String value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.CT, value != null ? new PdfString(value) : null);
    }

    public void setPlayers(MediaPlayers value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.PL, PdfObjectWrapper.getBaseObject(value));
    }

    public void setPreferences(Viability value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.BE, PdfObjectWrapper.getBaseObject(value));
    }

    public void setRequirements(Viability value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.MH, PdfObjectWrapper.getBaseObject(value));
    }

    public void setTempFilePermission(TempFilePermissionEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.P, PdfDictionary.class).put(PdfName.TF, value != null ? value.getCode() : null);
    }

    public static enum TempFilePermissionEnum {
        Never(new PdfString("TEMPNEVER")),
        ContentExtraction(new PdfString("TEMPEXTRACT")),
        Accessibility(new PdfString("TEMPACCESS")),
        Always(new PdfString("TEMPALWAYS"));

        private static Map<PdfString, TempFilePermissionEnum> map;
        private final PdfString code;

        static {
            map = new HashMap<PdfString, TempFilePermissionEnum>();
            TempFilePermissionEnum[] tempFilePermissionEnumArray = TempFilePermissionEnum.values();
            int n = tempFilePermissionEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                TempFilePermissionEnum value = tempFilePermissionEnumArray[n2];
                map.put(value.getCode(), value);
                ++n2;
            }
        }

        private TempFilePermissionEnum(PdfString code) {
            this.code = code;
        }

        public PdfString getCode() {
            return this.code;
        }

        public static TempFilePermissionEnum valueOf(String string) {
            return Enum.valueOf(TempFilePermissionEnum.class, string);
        }
    }

    public static class Viability
    extends PdfObjectWrapper<PdfDictionary> {
        private Viability(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public Viability clone(Document context) {
            return (Viability)super.clone(context);
        }

        public URL getBaseURL() {
            PdfString baseURLObject = (PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.BU);
            try {
                return baseURLObject != null ? new URL(baseURLObject.getStringValue()) : null;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public void setBaseURL(URL value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.BU, value != null ? new PdfString(value.toString()) : null);
        }
    }
}

