/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.multimedia;

import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.multimedia.MediaClip;
import org.pdfclown.documents.multimedia.MediaPlayParameters;
import org.pdfclown.documents.multimedia.MediaScreenParameters;
import org.pdfclown.documents.multimedia.Rendition;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;

@PDF(value=VersionEnum.PDF15)
public final class MediaRendition
extends Rendition {
    public MediaRendition(MediaClip clip) {
        super(clip.getDocument(), PdfName.MR);
        this.setClip(clip);
    }

    MediaRendition(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public MediaRendition clone(Document context) {
        return (MediaRendition)super.clone(context);
    }

    public MediaClip getClip() {
        return MediaClip.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.C));
    }

    public MediaPlayParameters getPlayParameters() {
        return new MediaPlayParameters(((PdfDictionary)this.getBaseDataObject()).get(PdfName.P, PdfDictionary.class));
    }

    public MediaScreenParameters getScreenParameters() {
        return new MediaScreenParameters(((PdfDictionary)this.getBaseDataObject()).get(PdfName.SP, PdfDictionary.class));
    }

    public void setClip(MediaClip value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.C, PdfObjectWrapper.getBaseObject(value));
    }

    public void setPlayParameters(MediaPlayParameters value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.P, PdfObjectWrapper.getBaseObject(value));
    }

    public void setScreenParameters(MediaScreenParameters value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.SP, PdfObjectWrapper.getBaseObject(value));
    }
}

