/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.multimedia;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.colorSpaces.DeviceRGBColor;
import org.pdfclown.documents.multimedia.MonitorSpecifierEnum;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReal;

@PDF(value=VersionEnum.PDF15)
public class MediaScreenParameters
extends PdfObjectWrapper<PdfDictionary> {
    public MediaScreenParameters(Document context) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.MediaScreenParams}));
    }

    MediaScreenParameters(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public MediaScreenParameters clone(Document context) {
        return (MediaScreenParameters)super.clone(context);
    }

    public Viability getPreferences() {
        return new Viability(((PdfDictionary)this.getBaseDataObject()).get(PdfName.BE, PdfDictionary.class));
    }

    public Viability getRequirements() {
        return new Viability(((PdfDictionary)this.getBaseDataObject()).get(PdfName.MH, PdfDictionary.class));
    }

    public void setPreferences(Viability value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.BE, PdfObjectWrapper.getBaseObject(value));
    }

    public void setRequirements(Viability value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.MH, PdfObjectWrapper.getBaseObject(value));
    }

    public static class Viability
    extends PdfObjectWrapper<PdfDictionary> {
        private Viability(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public Viability clone(Document context) {
            return (Viability)super.clone(context);
        }

        public DeviceRGBColor getBackgroundColor() {
            return DeviceRGBColor.get((PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.B));
        }

        public double getBackgroundOpacity() {
            return (Double)PdfReal.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.O), 1.0);
        }

        public FloatingWindowParameters getFloatingWindowParameters() {
            return new FloatingWindowParameters(((PdfDictionary)this.getBaseDataObject()).get(PdfName.F, PdfDictionary.class));
        }

        public MonitorSpecifierEnum getMonitorSpecifier() {
            return MonitorSpecifierEnum.valueOf((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.M));
        }

        public WindowTypeEnum getWindowType() {
            return WindowTypeEnum.valueOf((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.W));
        }

        public void setBackgroundColor(DeviceRGBColor value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.B, PdfObjectWrapper.getBaseObject(value));
        }

        public void setBackgroundOpacity(double value) {
            if (value < 0.0) {
                value = 0.0;
            } else if (value > 1.0) {
                value = 1.0;
            }
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.O, PdfReal.get(value));
        }

        public void setFloatingWindowParameters(FloatingWindowParameters value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.F, PdfObjectWrapper.getBaseObject(value));
        }

        public void setMonitorSpecifier(MonitorSpecifierEnum value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.M, value != null ? value.getCode() : null);
        }

        public void setWindowType(WindowTypeEnum value) {
            ((PdfDictionary)this.getBaseDataObject()).put(PdfName.W, value != null ? value.getCode() : null);
        }

        public static class FloatingWindowParameters
        extends PdfObjectWrapper<PdfDictionary> {
            public FloatingWindowParameters(Dimension size) {
                super(new PdfDictionary(new PdfName[]{PdfName.Type}, new PdfDirectObject[]{PdfName.FWParams}));
                this.setSize(size);
            }

            private FloatingWindowParameters(PdfDirectObject baseObject) {
                super(baseObject);
            }

            @Override
            public FloatingWindowParameters clone(Document context) {
                return (FloatingWindowParameters)super.clone(context);
            }

            public LocationEnum getLocation() {
                return LocationEnum.valueOf((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.P));
            }

            public OffscreenBehaviorEnum getOffscreenBehavior() {
                return OffscreenBehaviorEnum.valueOf((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.O));
            }

            public RelatedWindowEnum getRelatedWindow() {
                return RelatedWindowEnum.valueOf((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.RT));
            }

            public ResizeBehaviorEnum getResizeBehavior() {
                return ResizeBehaviorEnum.valueOf((PdfInteger)((PdfDictionary)this.getBaseDataObject()).get(PdfName.R));
            }

            public Dimension getSize() {
                PdfArray sizeObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.D);
                return new Dimension(((PdfInteger)sizeObject.get(0)).getValue(), ((PdfInteger)sizeObject.get(1)).getValue());
            }

            public boolean isCloseable() {
                return (Boolean)PdfBoolean.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.UC), true);
            }

            public boolean isTitleBarVisible() {
                return (Boolean)PdfBoolean.getValue(((PdfDictionary)this.getBaseDataObject()).get(PdfName.T), true);
            }

            public void setCloseable(boolean value) {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.UC, PdfBoolean.get(value));
            }

            public void setLocation(LocationEnum value) {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.P, value != null ? value.getCode() : null);
            }

            public void setOffscreenBehavior(OffscreenBehaviorEnum value) {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.O, value != null ? value.getCode() : null);
            }

            public void setRelatedWindow(RelatedWindowEnum value) {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.RT, value != null ? value.getCode() : null);
            }

            public void setResizeBehavior(ResizeBehaviorEnum value) {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.R, value != null ? value.getCode() : null);
            }

            public void setSize(Dimension value) {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.D, new PdfArray(PdfInteger.get(value.getWidth()), PdfInteger.get(value.getHeight())));
            }

            public void setTitleBarVisible(boolean value) {
                ((PdfDictionary)this.getBaseDataObject()).put(PdfName.T, PdfBoolean.get(value));
            }

            public static enum LocationEnum {
                UpperLeft(new PdfInteger(0)),
                UpperCenter(new PdfInteger(1)),
                UpperRight(new PdfInteger(2)),
                CenterLeft(new PdfInteger(3)),
                Center(new PdfInteger(4)),
                CenterRight(new PdfInteger(5)),
                LowerLeft(new PdfInteger(6)),
                LowerCenter(new PdfInteger(7)),
                LowerRight(new PdfInteger(8));

                private static Map<PdfInteger, LocationEnum> map;
                private final PdfInteger code;

                static {
                    map = new HashMap<PdfInteger, LocationEnum>();
                    LocationEnum[] locationEnumArray = LocationEnum.values();
                    int n = locationEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LocationEnum value = locationEnumArray[n2];
                        map.put(value.getCode(), value);
                        ++n2;
                    }
                }

                private LocationEnum(PdfInteger code) {
                    this.code = code;
                }

                public PdfInteger getCode() {
                    return this.code;
                }

                public static LocationEnum valueOf(String string) {
                    return Enum.valueOf(LocationEnum.class, string);
                }
            }

            public static enum OffscreenBehaviorEnum {
                None(new PdfInteger(0)),
                Adapt(new PdfInteger(1)),
                NonViable(new PdfInteger(2));

                private static Map<PdfInteger, OffscreenBehaviorEnum> map;
                private final PdfInteger code;

                static {
                    map = new HashMap<PdfInteger, OffscreenBehaviorEnum>();
                    OffscreenBehaviorEnum[] offscreenBehaviorEnumArray = OffscreenBehaviorEnum.values();
                    int n = offscreenBehaviorEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        OffscreenBehaviorEnum value = offscreenBehaviorEnumArray[n2];
                        map.put(value.getCode(), value);
                        ++n2;
                    }
                }

                private OffscreenBehaviorEnum(PdfInteger code) {
                    this.code = code;
                }

                public PdfInteger getCode() {
                    return this.code;
                }

                public static OffscreenBehaviorEnum valueOf(String string) {
                    return Enum.valueOf(OffscreenBehaviorEnum.class, string);
                }
            }

            public static enum RelatedWindowEnum {
                Document(new PdfInteger(0)),
                Application(new PdfInteger(1)),
                Desktop(new PdfInteger(2)),
                Custom(new PdfInteger(3));

                private static Map<PdfInteger, RelatedWindowEnum> map;
                private final PdfInteger code;

                static {
                    map = new HashMap<PdfInteger, RelatedWindowEnum>();
                    RelatedWindowEnum[] relatedWindowEnumArray = RelatedWindowEnum.values();
                    int n = relatedWindowEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RelatedWindowEnum value = relatedWindowEnumArray[n2];
                        map.put(value.getCode(), value);
                        ++n2;
                    }
                }

                private RelatedWindowEnum(PdfInteger code) {
                    this.code = code;
                }

                public PdfInteger getCode() {
                    return this.code;
                }

                public static RelatedWindowEnum valueOf(String string) {
                    return Enum.valueOf(RelatedWindowEnum.class, string);
                }
            }

            public static enum ResizeBehaviorEnum {
                None(new PdfInteger(0)),
                AspectRatioLocked(new PdfInteger(1)),
                Free(new PdfInteger(2));

                private static Map<PdfInteger, ResizeBehaviorEnum> map;
                private final PdfInteger code;

                static {
                    map = new HashMap<PdfInteger, ResizeBehaviorEnum>();
                    ResizeBehaviorEnum[] resizeBehaviorEnumArray = ResizeBehaviorEnum.values();
                    int n = resizeBehaviorEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ResizeBehaviorEnum value = resizeBehaviorEnumArray[n2];
                        map.put(value.getCode(), value);
                        ++n2;
                    }
                }

                private ResizeBehaviorEnum(PdfInteger code) {
                    this.code = code;
                }

                public PdfInteger getCode() {
                    return this.code;
                }

                public static ResizeBehaviorEnum valueOf(String string) {
                    return Enum.valueOf(ResizeBehaviorEnum.class, string);
                }
            }
        }

        public static enum WindowTypeEnum {
            Floating(new PdfInteger(0)),
            FullScreen(new PdfInteger(1)),
            Hidden(new PdfInteger(2)),
            Annotation(new PdfInteger(3));

            private static Map<PdfInteger, WindowTypeEnum> map;
            private final PdfInteger code;

            static {
                map = new HashMap<PdfInteger, WindowTypeEnum>();
                WindowTypeEnum[] windowTypeEnumArray = WindowTypeEnum.values();
                int n = windowTypeEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WindowTypeEnum value = windowTypeEnumArray[n2];
                    map.put(value.getCode(), value);
                    ++n2;
                }
            }

            private WindowTypeEnum(PdfInteger code) {
                this.code = code;
            }

            public PdfInteger getCode() {
                return this.code;
            }

            public static WindowTypeEnum valueOf(String string) {
                return Enum.valueOf(WindowTypeEnum.class, string);
            }
        }
    }
}

