/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.multimedia;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.Version;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.interchange.access.LanguageIdentifier;
import org.pdfclown.documents.multimedia.MediaRendition;
import org.pdfclown.documents.multimedia.SelectorRendition;
import org.pdfclown.documents.multimedia.SoftwareIdentifier;
import org.pdfclown.objects.Array;
import org.pdfclown.objects.IPdfNamedObjectWrapper;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfBoolean;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfString;
import org.pdfclown.util.math.Interval;

@PDF(value=VersionEnum.PDF15)
public abstract class Rendition
extends PdfObjectWrapper<PdfDictionary>
implements IPdfNamedObjectWrapper {
    public static Rendition wrap(PdfDirectObject baseObject) {
        if (baseObject == null) {
            return null;
        }
        PdfName subtype = (PdfName)((PdfDictionary)baseObject.resolve()).get(PdfName.S);
        if (PdfName.MR.equals(subtype)) {
            return new MediaRendition(baseObject);
        }
        if (PdfName.SR.equals(subtype)) {
            return new SelectorRendition(baseObject);
        }
        throw new IllegalArgumentException("'baseObject' parameter doesn't represent a valid rendition object.");
    }

    protected Rendition(Document context, PdfName subtype) {
        super(context, new PdfDictionary(new PdfName[]{PdfName.Type, PdfName.S}, new PdfDirectObject[]{PdfName.Rendition, subtype}));
    }

    protected Rendition(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public Viability getPreferences() {
        return new Viability(((PdfDictionary)this.getBaseDataObject()).get(PdfName.BE, PdfDictionary.class));
    }

    public Viability getRequirements() {
        return new Viability(((PdfDictionary)this.getBaseDataObject()).get(PdfName.MH, PdfDictionary.class));
    }

    public void setPreferences(Viability value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.BE, PdfObjectWrapper.getBaseObject(value));
    }

    public void setRequirements(Viability value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.MH, PdfObjectWrapper.getBaseObject(value));
    }

    @Override
    public PdfString getName() {
        return this.retrieveName();
    }

    @Override
    public PdfDirectObject getNamedBaseObject() {
        return this.retrieveNamedBaseObject();
    }

    @Override
    protected PdfString retrieveName() {
        return (PdfString)((PdfDictionary)this.getBaseDataObject()).get(PdfName.N);
    }

    public static class Viability
    extends PdfObjectWrapper<PdfDictionary> {
        private Viability(PdfDirectObject baseObject) {
            super(baseObject);
        }

        @Override
        public Viability clone(Document context) {
            return (Viability)super.clone(context);
        }

        public Integer getBandwidth() {
            return (Integer)PdfInteger.getValue(this.getMediaCriteria().get(PdfName.R));
        }

        public Integer getScreenDepth() {
            PdfDictionary screenDepthObject = (PdfDictionary)this.getMediaCriteria().get(PdfName.D);
            return screenDepthObject != null ? ((PdfInteger)screenDepthObject.get(PdfName.V)).getValue() : null;
        }

        public Dimension getScreenSize() {
            PdfDictionary screenSizeObject = (PdfDictionary)this.getMediaCriteria().get(PdfName.Z);
            if (screenSizeObject == null) {
                return null;
            }
            PdfArray screenSizeValueObject = (PdfArray)screenSizeObject.get(PdfName.V);
            return screenSizeValueObject != null ? new Dimension(((PdfInteger)screenSizeValueObject.get(0)).getValue(), ((PdfInteger)screenSizeValueObject.get(1)).getValue()) : null;
        }

        public Array<SoftwareIdentifier> getRenderers() {
            return Array.wrap(SoftwareIdentifier.class, this.getMediaCriteria().get(PdfName.V, PdfArray.class));
        }

        public Interval<Version> getVersion() {
            PdfArray pdfVersionArray = (PdfArray)this.getMediaCriteria().get(PdfName.P);
            return pdfVersionArray != null && !pdfVersionArray.isEmpty() ? new Interval<Object>(Version.get((PdfName)pdfVersionArray.get(0)), (pdfVersionArray.size() > 1 ? Version.get((PdfName)pdfVersionArray.get(1)) : null)) : null;
        }

        public List<LanguageIdentifier> getLanguages() {
            ArrayList<LanguageIdentifier> languages = new ArrayList<LanguageIdentifier>();
            PdfArray languagesObject = (PdfArray)this.getMediaCriteria().get(PdfName.L);
            if (languagesObject != null) {
                for (PdfDirectObject languageObject : languagesObject) {
                    languages.add(LanguageIdentifier.wrap(languageObject));
                }
            }
            return languages;
        }

        public Boolean isAudioDescriptionEnabled() {
            return (Boolean)PdfBoolean.getValue(this.getMediaCriteria().get(PdfName.A));
        }

        public Boolean isAudioOverdubEnabled() {
            return (Boolean)PdfBoolean.getValue(this.getMediaCriteria().get(PdfName.O));
        }

        public Boolean isSubtitleEnabled() {
            return (Boolean)PdfBoolean.getValue(this.getMediaCriteria().get(PdfName.S));
        }

        public Boolean isTextCaptionEnabled() {
            return (Boolean)PdfBoolean.getValue(this.getMediaCriteria().get(PdfName.C));
        }

        private PdfDictionary getMediaCriteria() {
            return ((PdfDictionary)this.getBaseDataObject()).resolve(PdfName.C, PdfDictionary.class);
        }
    }
}

