/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.files;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Random;
import org.pdfclown.Version;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.FileInputStream;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.bytes.OutputStream;
import org.pdfclown.documents.Document;
import org.pdfclown.files.FileIdentifier;
import org.pdfclown.files.IndirectObjects;
import org.pdfclown.files.SerializationModeEnum;
import org.pdfclown.objects.Cloner;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfIndirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.tokens.Reader;
import org.pdfclown.tokens.Writer;
import org.pdfclown.tokens.XRefEntry;
import org.pdfclown.util.NotImplementedException;
import org.pdfclown.util.StringUtils;

public final class File
implements Closeable {
    private static Random hashCodeGenerator = new Random();
    private final Configuration configuration = new Configuration(this);
    private final Document document;
    private final int hashCode = hashCodeGenerator.nextInt();
    private final IndirectObjects indirectObjects;
    private String path;
    private Reader reader;
    private final PdfDictionary trailer;
    private final Version version;
    private Cloner cloner;

    public File() {
        this.version = VersionEnum.PDF14.getVersion();
        this.trailer = this.prepareTrailer(new PdfDictionary());
        this.indirectObjects = new IndirectObjects(this, null);
        this.document = new Document(this);
    }

    public File(String path) throws FileNotFoundException {
        this(new FileInputStream(new RandomAccessFile(path, "r")));
        this.path = path;
    }

    public File(IInputStream stream) {
        this.reader = new Reader(stream, this);
        Reader.FileInfo info = this.reader.readInfo();
        this.version = info.getVersion();
        this.trailer = this.prepareTrailer(info.getTrailer());
        if (this.trailer.containsKey(PdfName.Encrypt)) {
            throw new NotImplementedException("Encrypted files are currently not supported.");
        }
        this.indirectObjects = new IndirectObjects(this, info.getXrefEntries());
        this.document = new Document(this.trailer.get(PdfName.Root));
        this.document.getConfiguration().setXrefMode(PdfName.XRef.equals(this.trailer.get(PdfName.Type)) ? Document.Configuration.XRefModeEnum.Compressed : Document.Configuration.XRefModeEnum.Plain);
    }

    public Cloner getCloner() {
        if (this.cloner == null) {
            this.cloner = new Cloner(this);
        }
        return this.cloner;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Document getDocument() {
        return this.document;
    }

    public FileIdentifier getID() {
        return FileIdentifier.wrap(this.getTrailer().get(PdfName.ID));
    }

    public IndirectObjects getIndirectObjects() {
        return this.indirectObjects;
    }

    public String getPath() {
        return this.path;
    }

    public Reader getReader() {
        return this.reader;
    }

    public PdfDictionary getTrailer() {
        return this.trailer;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public PdfReference register(PdfDataObject object) {
        return this.indirectObjects.add(object).getReference();
    }

    public void save() throws IOException {
        this.save(SerializationModeEnum.Standard);
    }

    public void save(SerializationModeEnum mode) throws IOException {
        if (!new java.io.File(this.path).exists()) {
            throw new FileNotFoundException("No valid source path available.");
        }
        this.save(this.getTempPath(), mode);
    }

    public void save(String path, SerializationModeEnum mode) throws IOException {
        this.save(new java.io.File(path), mode);
    }

    public void save(java.io.File file, SerializationModeEnum mode) throws IOException {
        OutputStream outputStream;
        BufferedOutputStream baseOutputStream;
        try {
            file.createNewFile();
            baseOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            outputStream = new OutputStream(baseOutputStream);
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(file.getPath()) + " file couldn't be created.", e);
        }
        try {
            this.save(outputStream, mode);
            baseOutputStream.flush();
            baseOutputStream.close();
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(file.getPath()) + " file writing has failed.", e);
        }
    }

    public void save(IOutputStream stream, SerializationModeEnum mode) {
        if (this.getReader() == null) {
            try {
                Package package_ = this.getClass().getPackage();
                this.getDocument().getInformation().setProducer(String.valueOf(package_.getSpecificationTitle()) + " " + package_.getSpecificationVersion());
            }
            catch (Exception package_) {
                // empty catch block
            }
        }
        Writer writer = Writer.get(this, stream);
        writer.write(mode);
    }

    public void setCloner(Cloner value) {
        this.cloner = value;
    }

    public void setPath(String value) {
        this.path = value;
    }

    public void unregister(PdfReference reference) {
        this.indirectObjects.remove(reference.getObjectNumber());
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            java.io.File sourceFile = new java.io.File(this.getTempPath());
            if (sourceFile.exists()) {
                java.io.File targetFile = new java.io.File(this.path);
                targetFile.delete();
                sourceFile.renameTo(targetFile);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private String getTempPath() {
        return this.path == null ? null : String.valueOf(this.path) + ".tmp";
    }

    private PdfDictionary prepareTrailer(PdfDictionary trailer) {
        return (PdfDictionary)new ImplicitContainer(this, trailer).getDataObject();
    }

    public static final class Configuration {
        private DecimalFormat realFormat;
        private final File file;

        Configuration(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public DecimalFormat getRealFormat() {
            if (this.realFormat == null) {
                this.setRealFormat(5);
            }
            return this.realFormat;
        }

        public void setRealFormat(DecimalFormat value) {
            this.realFormat = value;
        }

        public void setRealFormat(int decimalPlacesCount) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            this.setRealFormat(new DecimalFormat("0." + StringUtils.repeat("#", decimalPlacesCount), symbols));
        }
    }

    private static final class ImplicitContainer
    extends PdfIndirectObject {
        public ImplicitContainer(File file, PdfDataObject dataObject) {
            super(file, dataObject, new XRefEntry(Integer.MIN_VALUE, Integer.MIN_VALUE));
        }
    }
}

