/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.files;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.pdfclown.files.File;
import org.pdfclown.objects.Cloner;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfIndirectObject;
import org.pdfclown.tokens.XRefEntry;
import org.pdfclown.util.NotImplementedException;

public final class IndirectObjects
implements List<PdfIndirectObject> {
    private final File file;
    private final Hashtable<Integer, PdfIndirectObject> importedObjects = new Hashtable();
    private final TreeMap<Integer, PdfIndirectObject> modifiedObjects = new TreeMap();
    private final TreeMap<Integer, PdfIndirectObject> wokenObjects = new TreeMap();
    private int lastObjectNumber;
    private final SortedMap<Integer, XRefEntry> xrefEntries;

    IndirectObjects(File file, SortedMap<Integer, XRefEntry> xrefEntries) {
        this.file = file;
        this.xrefEntries = xrefEntries;
        if (this.xrefEntries == null) {
            this.lastObjectNumber = 0;
            this.modifiedObjects.put(this.lastObjectNumber, new PdfIndirectObject(this.file, null, new XRefEntry(this.lastObjectNumber, 65535, 0, XRefEntry.UsageEnum.Free)));
        } else {
            this.lastObjectNumber = xrefEntries.lastKey();
        }
    }

    public PdfIndirectObject add(PdfDataObject object) {
        PdfIndirectObject indirectObject = new PdfIndirectObject(this.file, object, new XRefEntry(++this.lastObjectNumber, 0));
        this.modifiedObjects.put(this.lastObjectNumber, indirectObject);
        return indirectObject;
    }

    public PdfIndirectObject addExternal(PdfIndirectObject object) {
        return this.addExternal(object, this.file.getCloner());
    }

    public PdfIndirectObject addExternal(PdfIndirectObject object, Cloner cloner) {
        if (cloner.getContext() != this.file) {
            throw new IllegalArgumentException("cloner file context incompatible");
        }
        PdfIndirectObject indirectObject = this.importedObjects.get(object.hashCode());
        if (indirectObject == null) {
            indirectObject = this.add((PdfDataObject)null);
            this.importedObjects.put(object.hashCode(), indirectObject);
            indirectObject.setDataObject((PdfDataObject)object.getDataObject().accept(cloner, null));
        }
        return indirectObject;
    }

    public Collection<? extends PdfIndirectObject> addExternal(Collection<? extends PdfIndirectObject> objects) {
        ArrayList<PdfIndirectObject> addedObjects = new ArrayList<PdfIndirectObject>(objects.size());
        for (PdfIndirectObject pdfIndirectObject : objects) {
            addedObjects.add(this.addExternal(pdfIndirectObject));
        }
        return addedObjects;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void add(int index, PdfIndirectObject object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends PdfIndirectObject> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PdfIndirectObject get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        PdfIndirectObject object = this.modifiedObjects.get(index);
        if (object == null && (object = this.wokenObjects.get(index)) == null) {
            XRefEntry xrefEntry = (XRefEntry)this.xrefEntries.get(index);
            if (xrefEntry == null) {
                xrefEntry = new XRefEntry(index, 65535, 0, XRefEntry.UsageEnum.Free);
                this.xrefEntries.put(index, xrefEntry);
            }
            object = new PdfIndirectObject(this.file, null, xrefEntry);
            this.wokenObjects.put(index, object);
        }
        return object;
    }

    @Override
    public int indexOf(Object object) {
        if (((PdfIndirectObject)object).getFile() != this.file) {
            return -1;
        }
        return ((PdfIndirectObject)object).getReference().getObjectNumber();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public ListIterator<PdfIndirectObject> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<PdfIndirectObject> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public PdfIndirectObject remove(int index) {
        PdfIndirectObject old = this.get(index);
        if (old.isInUse()) {
            return this.update(new PdfIndirectObject(this.file, null, new XRefEntry(index, 65535, 0, XRefEntry.UsageEnum.Free)));
        }
        return old;
    }

    @Override
    public PdfIndirectObject set(int index, PdfIndirectObject object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<PdfIndirectObject> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException();
    }

    @Override
    public boolean add(PdfIndirectObject object) {
        return this.addExternal(object) != null;
    }

    @Override
    public boolean addAll(Collection<? extends PdfIndirectObject> objects) {
        return !this.addExternal(objects).isEmpty();
    }

    @Override
    public void clear() {
        int index = 0;
        int length = this.size();
        while (index < length) {
            this.remove(index);
            ++index;
        }
    }

    @Override
    public boolean contains(Object object) {
        try {
            return this.get(((PdfIndirectObject)object).getReference().getObjectNumber()) == object;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        for (Object object : objects) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        throw new NotImplementedException();
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        for (PdfIndirectObject object : this) {
            if (!object.isInUse()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object object) {
        if (!this.contains(object)) {
            return false;
        }
        this.remove(((PdfIndirectObject)object).getReference().getObjectNumber());
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean changed = false;
        for (Object object : objects) {
            changed |= this.remove(object);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        boolean changed = false;
        for (PdfIndirectObject object : this) {
            if (objects.contains(object)) continue;
            changed |= this.remove(object);
        }
        return changed;
    }

    @Override
    public int size() {
        return this.lastObjectNumber + 1;
    }

    public PdfIndirectObject[] toArray() {
        throw new NotImplementedException();
    }

    @Override
    public <T> T[] toArray(T[] objects) {
        throw new NotImplementedException();
    }

    @Override
    public Iterator<PdfIndirectObject> iterator() {
        return new Iterator<PdfIndirectObject>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < IndirectObjects.this.size();
            }

            @Override
            public PdfIndirectObject next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return IndirectObjects.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public PdfIndirectObject addVirtual(PdfIndirectObject object) {
        XRefEntry xref = object.getXrefEntry();
        xref.setNumber(++this.lastObjectNumber);
        xref.setGeneration(0);
        this.modifiedObjects.put(this.lastObjectNumber, object);
        return object;
    }

    public TreeMap<Integer, PdfIndirectObject> getModifiedObjects() {
        return this.modifiedObjects;
    }

    public PdfIndirectObject update(PdfIndirectObject object) {
        int index = object.getReference().getObjectNumber();
        PdfIndirectObject old = this.get(index);
        if (old != object) {
            old.dropFile();
        }
        this.modifiedObjects.put(index, object);
        this.wokenObjects.remove(index);
        object.dropOriginal();
        return old;
    }
}

