/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.pdfclown.documents.Document;
import org.pdfclown.objects.IPdfObjectWrapper;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.util.NotImplementedException;

public class Array<TItem extends IPdfObjectWrapper>
extends PdfObjectWrapper<PdfArray>
implements List<TItem> {
    private final IWrapper<TItem> itemWrapper;

    public static <TItem extends IPdfObjectWrapper> Array<TItem> wrap(Class<TItem> itemClass, PdfDirectObject baseObject) {
        return baseObject != null ? new Array<TItem>(itemClass, baseObject) : null;
    }

    public static <TItem extends IPdfObjectWrapper> Array<TItem> wrap(IWrapper<TItem> itemWrapper, PdfDirectObject baseObject) {
        return baseObject != null ? new Array<TItem>(itemWrapper, baseObject) : null;
    }

    public Array(Document context, Class<TItem> itemClass) {
        this(context, itemClass, new PdfArray());
    }

    public Array(Document context, IWrapper<TItem> itemWrapper) {
        this(context, itemWrapper, new PdfArray());
    }

    public Array(Document context, Class<TItem> itemClass, PdfArray baseDataObject) {
        this(context, new DefaultWrapper<TItem>(itemClass), baseDataObject);
    }

    public Array(Document context, IWrapper<TItem> itemWrapper, PdfArray baseDataObject) {
        super(context, baseDataObject);
        this.itemWrapper = itemWrapper;
    }

    protected Array(Class<TItem> itemClass, PdfDirectObject baseObject) {
        this(new DefaultWrapper<TItem>(itemClass), baseObject);
    }

    protected Array(IWrapper<TItem> itemWrapper, PdfDirectObject baseObject) {
        super(baseObject);
        this.itemWrapper = itemWrapper;
    }

    @Override
    public Array<TItem> clone(Document context) {
        return (Array)super.clone(context);
    }

    @Override
    public boolean add(TItem item) {
        return ((PdfArray)this.getBaseDataObject()).add(item.getBaseObject());
    }

    @Override
    public void add(int index, TItem item) {
        ((PdfArray)this.getBaseDataObject()).add(index, item.getBaseObject());
    }

    @Override
    public boolean addAll(Collection<? extends TItem> items) {
        for (IPdfObjectWrapper item : items) {
            this.add((TItem)item);
        }
        return !items.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends TItem> items) {
        for (IPdfObjectWrapper item : items) {
            this.add(index, (TItem)item);
        }
        return !items.isEmpty();
    }

    @Override
    public void clear() {
        int index = this.size();
        while (index-- > 0) {
            this.remove(index);
        }
    }

    @Override
    public boolean contains(Object item) {
        return ((PdfArray)this.getBaseDataObject()).contains(((IPdfObjectWrapper)item).getBaseObject());
    }

    @Override
    public boolean containsAll(Collection<?> items) {
        for (Object item : items) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public TItem get(int index) {
        return (TItem)((IPdfObjectWrapper)this.itemWrapper.wrap(((PdfArray)this.getBaseDataObject()).get(index)));
    }

    @Override
    public int indexOf(Object item) {
        return ((PdfArray)this.getBaseDataObject()).indexOf(((IPdfObjectWrapper)item).getBaseObject());
    }

    @Override
    public boolean isEmpty() {
        return ((PdfArray)this.getBaseDataObject()).isEmpty();
    }

    @Override
    public Iterator<TItem> iterator() {
        return new Iterator<TItem>(){
            private int index = 0;
            private final int size;
            {
                this.size = Array.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public TItem next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Array.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int lastIndexOf(Object item) {
        return ((PdfArray)this.getBaseDataObject()).lastIndexOf(((IPdfObjectWrapper)item).getBaseObject());
    }

    @Override
    public ListIterator<TItem> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<TItem> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public boolean remove(Object item) {
        return ((PdfArray)this.getBaseDataObject()).remove(((IPdfObjectWrapper)item).getBaseObject());
    }

    @Override
    public TItem remove(int index) {
        return (TItem)((IPdfObjectWrapper)this.itemWrapper.wrap(((PdfArray)this.getBaseDataObject()).remove(index)));
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        boolean changed = false;
        for (Object item : items) {
            changed |= this.remove(item);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> items) {
        throw new NotImplementedException();
    }

    @Override
    public TItem set(int index, TItem item) {
        return (TItem)((IPdfObjectWrapper)this.itemWrapper.wrap(((PdfArray)this.getBaseDataObject()).set(index, item.getBaseObject())));
    }

    @Override
    public int size() {
        return ((PdfArray)this.getBaseDataObject()).size();
    }

    @Override
    public List<TItem> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException();
    }

    @Override
    public Object[] toArray() {
        throw new NotImplementedException();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        ArrayList<IPdfObjectWrapper> items = new ArrayList<IPdfObjectWrapper>();
        for (PdfDirectObject object : (PdfArray)this.getBaseDataObject()) {
            items.add((IPdfObjectWrapper)this.itemWrapper.wrap(object));
        }
        return items.toArray(array);
    }

    private static class DefaultWrapper<TItem>
    implements IWrapper<TItem> {
        private Method itemConstructor;

        DefaultWrapper(Class<TItem> itemClass) {
            try {
                this.itemConstructor = itemClass.getMethod("wrap", PdfDirectObject.class);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public TItem wrap(PdfDirectObject baseObject) {
            try {
                return (TItem)this.itemConstructor.invoke(null, baseObject);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface IWrapper<TItem> {
        public TItem wrap(PdfDirectObject var1);
    }
}

