/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfIndirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.tokens.Chunk;
import org.pdfclown.tokens.Encoding;
import org.pdfclown.tokens.XRefEntry;
import org.pdfclown.util.NotImplementedException;

public final class PdfDictionary
extends PdfDirectObject
implements Map<PdfName, PdfDirectObject> {
    private static final byte[] BeginDictionaryChunk = Encoding.Pdf.encode("<<");
    private static final byte[] EndDictionaryChunk = Encoding.Pdf.encode(">>");
    Map<PdfName, PdfDirectObject> entries;
    private PdfObject parent;
    private boolean updated;
    private boolean updateable = true;
    private boolean virtual;

    public PdfDictionary() {
        this.entries = new HashMap<PdfName, PdfDirectObject>();
    }

    public PdfDictionary(int capacity) {
        this.entries = new HashMap<PdfName, PdfDirectObject>(capacity);
    }

    public PdfDictionary(PdfName[] keys, PdfDirectObject[] values) {
        this(values.length);
        this.setUpdateable(false);
        int index = 0;
        while (index < values.length) {
            this.put(keys[index], values[index]);
            ++index;
        }
        this.setUpdateable(true);
    }

    public PdfDictionary(Map<PdfName, PdfDirectObject> entries) {
        this(entries.size());
        this.setUpdateable(false);
        for (Map.Entry<PdfName, PdfDirectObject> entry : entries.entrySet()) {
            this.put(entry.getKey(), (PdfDirectObject)this.include(entry.getValue()));
        }
        this.setUpdateable(true);
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public PdfDictionary clone(File context) {
        return (PdfDictionary)super.clone(context);
    }

    @Override
    public int compareTo(PdfDirectObject obj) {
        throw new NotImplementedException();
    }

    public <T extends PdfDataObject> PdfDirectObject get(PdfName key, Class<T> valueClass) {
        return this.get(key, valueClass, true);
    }

    public <T extends PdfDataObject> PdfDirectObject get(PdfName key, Class<T> valueClass, boolean direct) {
        PdfDirectObject value = this.get(key);
        if (value == null) {
            try {
                value = (PdfDirectObject)this.include(direct ? (PdfDataObject)valueClass.newInstance() : new PdfIndirectObject(this.getFile(), (PdfDataObject)valueClass.newInstance(), new XRefEntry(0, 0)).getReference());
                this.entries.put(key, value);
                value.setVirtual(true);
            }
            catch (Exception e) {
                throw new RuntimeException(String.valueOf(valueClass.getSimpleName()) + " failed to instantiate.", e);
            }
        }
        return value;
    }

    public PdfName getKey(PdfDirectObject value) {
        for (Map.Entry<PdfName, PdfDirectObject> entry : this.entries.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public PdfObject getParent() {
        return this.parent;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public PdfDataObject resolve(PdfName key) {
        return PdfDictionary.resolve(this.get(key));
    }

    public <T extends PdfDataObject> T resolve(PdfName key, Class<T> valueClass) {
        return (T)PdfDictionary.resolve(this.get(key, valueClass));
    }

    @Override
    public void setUpdateable(boolean value) {
        this.updateable = value;
    }

    @Override
    public PdfDictionary swap(PdfObject other) {
        PdfDictionary otherDictionary = (PdfDictionary)other;
        Map<PdfName, PdfDirectObject> otherEntries = otherDictionary.entries;
        otherDictionary.entries = this.entries;
        otherDictionary.update();
        this.entries = otherEntries;
        this.update();
        return this;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<< ");
        for (Map.Entry<PdfName, PdfDirectObject> entry : this.entries.entrySet()) {
            buffer.append(entry.getKey().toString()).append(" ");
            buffer.append(PdfDirectObject.toString(entry.getValue())).append(" ");
        }
        buffer.append(">>");
        return buffer.toString();
    }

    @Override
    public void writeTo(IOutputStream stream, File context) {
        stream.write(BeginDictionaryChunk);
        for (Map.Entry<PdfName, PdfDirectObject> entry : this.entries.entrySet()) {
            PdfDirectObject value = entry.getValue();
            if (value != null && value.isVirtual()) continue;
            entry.getKey().writeTo(stream, context);
            stream.write(Chunk.Space);
            PdfDirectObject.writeTo(stream, context, value);
            stream.write(Chunk.Space);
        }
        stream.write(EndDictionaryChunk);
    }

    @Override
    public void clear() {
        for (PdfName key : new ArrayList<PdfName>(this.entries.keySet())) {
            this.remove(key);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entries.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.entries.containsValue(value);
    }

    @Override
    public Set<Map.Entry<PdfName, PdfDirectObject>> entrySet() {
        return this.entries.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) || object != null && object.getClass().equals(this.getClass()) && ((PdfDictionary)object).entries.equals(this.entries);
    }

    @Override
    public PdfDirectObject get(Object key) {
        return this.entries.get(key);
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Set<PdfName> keySet() {
        return this.entries.keySet();
    }

    @Override
    public PdfDirectObject put(PdfName key, PdfDirectObject value) {
        PdfDirectObject oldValue;
        if (value == null) {
            oldValue = this.remove(key);
        } else {
            value = (PdfDirectObject)this.include(value);
            oldValue = this.entries.put(key, value);
            this.exclude(oldValue);
            this.update();
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends PdfName, ? extends PdfDirectObject> entries) {
        for (Map.Entry<? extends PdfName, ? extends PdfDirectObject> entry : entries.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public PdfDirectObject remove(Object key) {
        PdfDirectObject oldValue = this.entries.remove(key);
        this.exclude(oldValue);
        this.update();
        return oldValue;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Collection<PdfDirectObject> values() {
        return this.entries.values();
    }

    @Override
    protected boolean isVirtual() {
        return this.virtual;
    }

    @Override
    protected void setUpdated(boolean value) {
        this.updated = value;
    }

    @Override
    protected void setVirtual(boolean value) {
        this.virtual = value;
    }

    @Override
    void setParent(PdfObject value) {
        this.parent = value;
    }
}

