/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfObject;

public final class PdfInteger
extends PdfNumber<Integer> {
    public static final PdfInteger Default = new PdfInteger(0);

    public static PdfInteger get(Integer value) {
        return value == null ? null : new PdfInteger(value);
    }

    public PdfInteger(int value) {
        this.setRawValue(value);
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public double getDoubleValue() {
        return ((Integer)this.getRawValue()).intValue();
    }

    @Override
    public float getFloatValue() {
        return ((Integer)this.getRawValue()).intValue();
    }

    @Override
    public int getIntValue() {
        return (Integer)this.getRawValue();
    }

    @Override
    public Integer getValue() {
        return super.getValue().intValue();
    }

    @Override
    public void writeTo(IOutputStream stream, File context) {
        stream.write(Integer.toString((Integer)this.getRawValue()));
    }

    @Override
    protected void setValue(Object value) {
        super.setValue(((Number)value).intValue());
    }
}

