/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.objects;

import java.io.IOException;
import java.util.Iterator;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.IBuffer;
import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.bytes.filters.Filter;
import org.pdfclown.documents.files.FileSpecification;
import org.pdfclown.documents.files.IFileResource;
import org.pdfclown.files.File;
import org.pdfclown.objects.IVisitor;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.tokens.Encoding;

public class PdfStream
extends PdfDataObject
implements IFileResource {
    private static final byte[] BeginStreamBodyChunk = Encoding.Pdf.encode("\nstream\n");
    private static final byte[] EndStreamBodyChunk = Encoding.Pdf.encode("\nendstream");
    IBuffer body;
    PdfDictionary header;
    private PdfObject parent;
    private boolean updateable = true;
    private boolean updated;
    private boolean virtual;
    private boolean bodyResolved;

    public PdfStream() {
        this(new PdfDictionary(), new Buffer());
    }

    public PdfStream(PdfDictionary header) {
        this(header, new Buffer());
    }

    public PdfStream(IBuffer body) {
        this(new PdfDictionary(), body);
    }

    public PdfStream(PdfDictionary header, IBuffer body) {
        this.header = (PdfDictionary)this.include(header);
        this.body = body;
        body.setDirty(false);
        body.addListener(new IBuffer.IListener(){

            @Override
            public void onChange(IBuffer buffer) {
                PdfStream.this.update();
            }
        });
    }

    @Override
    public PdfObject accept(IVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public PdfStream clone(File context) {
        return (PdfStream)super.clone(context);
    }

    public IBuffer getBody() {
        return this.getBody(true);
    }

    public IBuffer getBody(boolean decode) {
        PdfDirectObject filter;
        if (!this.bodyResolved) {
            FileSpecification<?> dataFile = this.getDataFile();
            if (dataFile != null) {
                this.setUpdateable(false);
                this.body.setLength(0);
                this.body.write(dataFile.getInputStream());
                this.body.setDirty(false);
                this.setUpdateable(true);
            }
            this.bodyResolved = true;
        }
        if (decode && (filter = this.getFilter()) != null) {
            this.header.setUpdateable(false);
            PdfDirectObject parameters = this.getParameters();
            if (filter instanceof PdfName) {
                this.body.decode(Filter.get((PdfName)filter), (PdfDictionary)parameters);
            } else {
                Iterator<PdfDirectObject> filterIterator = ((PdfArray)filter).iterator();
                Iterator<PdfDirectObject> parametersIterator = parameters != null ? ((PdfArray)parameters).iterator() : null;
                while (filterIterator.hasNext()) {
                    this.body.decode(Filter.get((PdfName)PdfStream.resolve(filterIterator.next())), (PdfDictionary)(parametersIterator != null ? PdfStream.resolve(parametersIterator.next()) : null));
                }
            }
            this.setFilter(null);
            this.header.setUpdateable(true);
        }
        return this.body;
    }

    public PdfDirectObject getFilter() {
        return (PdfDirectObject)(this.header.get(PdfName.F) == null ? this.header.resolve(PdfName.Filter) : this.header.resolve(PdfName.FFilter));
    }

    public PdfDictionary getHeader() {
        return this.header;
    }

    public PdfDirectObject getParameters() {
        return (PdfDirectObject)(this.header.get(PdfName.F) == null ? this.header.resolve(PdfName.DecodeParms) : this.header.resolve(PdfName.FDecodeParms));
    }

    @Override
    public PdfObject getParent() {
        return this.parent;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public void setDataFile(FileSpecification<?> value, boolean preserve) {
        PdfDirectObject dataFileObject;
        FileSpecification<?> oldDataFile = this.getDataFile();
        PdfDirectObject pdfDirectObject = dataFileObject = value != null ? value.getBaseObject() : null;
        if (value != null) {
            if (preserve) {
                if (oldDataFile != null) {
                    if (!this.bodyResolved) {
                        this.getBody(false);
                    }
                } else {
                    this.header.put(PdfName.FFilter, this.header.remove(PdfName.Filter));
                    this.header.put(PdfName.FDecodeParms, this.header.remove(PdfName.DecodeParms));
                    this.bodyResolved = true;
                }
                this.body.setDirty(true);
            } else {
                this.body.setLength(0);
                this.setFilter(null);
                this.setParameters(null);
                this.bodyResolved = false;
            }
        } else if (oldDataFile != null) {
            if (preserve) {
                this.getBody(false);
                this.header.put(PdfName.Filter, this.header.remove(PdfName.FFilter));
                this.header.put(PdfName.DecodeParms, this.header.remove(PdfName.FDecodeParms));
            } else {
                this.body.setLength(0);
                this.setFilter(null);
                this.setParameters(null);
                this.bodyResolved = true;
            }
        }
        this.header.put(PdfName.F, dataFileObject);
    }

    @Override
    public void setUpdateable(boolean value) {
        this.updateable = value;
    }

    @Override
    public PdfStream swap(PdfObject other) {
        PdfStream otherStream = (PdfStream)other;
        PdfDictionary otherHeader = otherStream.header;
        IBuffer otherBody = otherStream.body;
        otherStream.header = this.header;
        otherStream.body = this.body;
        otherStream.update();
        this.header = otherHeader;
        this.body = otherBody;
        this.update();
        return this;
    }

    @Override
    public void writeTo(IOutputStream stream, File context) {
        byte[] bodyData;
        boolean bodyUnencoded;
        boolean encodeBody;
        this.header.setUpdateable(false);
        FileSpecification<?> dataFile = this.getDataFile();
        boolean bl = encodeBody = dataFile == null || this.bodyResolved && this.body.isDirty();
        if (encodeBody) {
            PdfDirectObject filterObject = this.getFilter();
            if (filterObject == null) {
                bodyUnencoded = true;
                filterObject = PdfName.FlateDecode;
                bodyData = this.body.encode(Filter.get((PdfName)filterObject), null);
                this.setFilter(filterObject);
            } else {
                bodyUnencoded = false;
                bodyData = this.body.toByteArray();
            }
            if (dataFile != null) {
                try {
                    IOutputStream dataFileOutputStream = dataFile.getOutputStream();
                    dataFileOutputStream.write(bodyData);
                    dataFileOutputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Data writing into " + dataFile.getPath() + " failed.", e);
                }
                bodyData = new byte[]{};
            }
        } else {
            bodyUnencoded = false;
            bodyData = new byte[]{};
        }
        this.header.put(PdfName.Length, PdfInteger.get(bodyData.length));
        this.header.writeTo(stream, context);
        if (bodyUnencoded) {
            this.header.put(PdfName.Length, PdfInteger.get((int)this.body.getLength()));
            this.setFilter(null);
        }
        stream.write(BeginStreamBodyChunk);
        stream.write(bodyData);
        stream.write(EndStreamBodyChunk);
        this.header.setUpdateable(true);
    }

    @Override
    @PDF(value=VersionEnum.PDF12)
    public FileSpecification<?> getDataFile() {
        return FileSpecification.wrap(this.header.get(PdfName.F));
    }

    @Override
    public void setDataFile(FileSpecification<?> value) {
        this.setDataFile(value, false);
    }

    @Override
    protected boolean isVirtual() {
        return this.virtual;
    }

    protected void setFilter(PdfDirectObject value) {
        this.header.put(this.header.get(PdfName.F) == null ? PdfName.Filter : PdfName.FFilter, value);
    }

    protected void setParameters(PdfDirectObject value) {
        this.header.put(this.header.get(PdfName.F) == null ? PdfName.DecodeParms : PdfName.FDecodeParms, value);
    }

    @Override
    protected void setUpdated(boolean value) {
        this.updated = value;
    }

    @Override
    protected void setVirtual(boolean value) {
        this.virtual = value;
    }

    @Override
    void setParent(PdfObject value) {
        this.parent = value;
    }
}

