/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tokens;

import org.pdfclown.tokens.Encoding;
import org.pdfclown.util.BiMap;

public abstract class LatinEncoding
extends Encoding {
    protected BiMap<Integer, Character> chars;

    @Override
    public String decode(byte[] value) {
        return this.decode(value, 0, value.length);
    }

    @Override
    public String decode(byte[] value, int index, int length) {
        char[] stringChars = new char[length];
        int decodeIndex = index;
        int decodeLength = length + index;
        while (decodeIndex < decodeLength) {
            stringChars[decodeIndex - index] = ((Character)this.chars.get(value[decodeIndex] & 0xFF)).charValue();
            ++decodeIndex;
        }
        return new String(stringChars);
    }

    @Override
    public byte[] encode(String value) {
        char[] stringChars = value.toCharArray();
        byte[] stringBytes = new byte[stringChars.length];
        int index = 0;
        int length = stringChars.length;
        while (index < length) {
            Integer code = this.chars.getKey(Character.valueOf(stringChars[index]));
            if (code == null) {
                return null;
            }
            stringBytes[index] = code.byteValue();
            ++index;
        }
        return stringBytes;
    }
}

