/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tokens;

import org.pdfclown.bytes.IOutputStream;
import org.pdfclown.files.File;
import org.pdfclown.files.FileIdentifier;
import org.pdfclown.files.SerializationModeEnum;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfName;
import org.pdfclown.tokens.CompressedWriter;
import org.pdfclown.tokens.Encoding;
import org.pdfclown.tokens.PlainWriter;

public abstract class Writer {
    private static final byte[] BOFChunk = Encoding.Pdf.encode("%PDF-");
    private static final byte[] EOFChunk = Encoding.Pdf.encode("\n%%EOF\r\n");
    private static final byte[] HeaderBinaryHintChunk = new byte[]{10, 37, -128, -128, -128, -128, 10};
    private static final byte[] StartXRefChunk = Encoding.Pdf.encode("startxref\n");
    protected final File file;
    protected final IOutputStream stream;

    public static Writer get(File file, IOutputStream stream) {
        switch (file.getDocument().getConfiguration().getXrefMode()) {
            case Plain: {
                return new PlainWriter(file, stream);
            }
            case Compressed: {
                return new CompressedWriter(file, stream);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected Writer(File file, IOutputStream stream) {
        this.file = file;
        this.stream = stream;
    }

    public File getFile() {
        return this.file;
    }

    public IOutputStream getStream() {
        return this.stream;
    }

    public void write(SerializationModeEnum mode) {
        switch (mode) {
            case Incremental: {
                if (this.file.getReader() != null) {
                    this.writeIncremental();
                    break;
                }
            }
            case Standard: {
                this.writeStandard();
                break;
            }
            case Linearized: {
                this.writeLinearized();
            }
        }
    }

    protected void updateTrailer(PdfDictionary trailer, IOutputStream stream) {
        FileIdentifier identifier = FileIdentifier.wrap(trailer.get(PdfName.ID));
        if (identifier == null) {
            identifier = new FileIdentifier();
            trailer.put(PdfName.ID, identifier.getBaseObject());
        }
        identifier.update(this);
    }

    protected final void writeHeader() {
        this.stream.write(BOFChunk);
        this.stream.write(this.file.getDocument().getVersion().toString());
        this.stream.write(HeaderBinaryHintChunk);
    }

    protected abstract void writeIncremental();

    protected abstract void writeLinearized();

    protected abstract void writeStandard();

    protected final void writeTail(long startxref) {
        this.stream.write(StartXRefChunk);
        this.stream.write(Long.toString(startxref));
        this.stream.write(EOFChunk);
    }
}

