/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tools;

import java.util.HashSet;
import org.pdfclown.files.File;
import org.pdfclown.files.IndirectObjects;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.Visitor;

public final class Optimizer {
    public static void removeOrphanedObjects(File file) {
        final HashSet aliveObjectNumbers = new HashSet();
        Visitor visitor = new Visitor(){

            @Override
            public PdfObject visit(PdfReference object, Object data) {
                Integer objectNumber = object.getReference().getObjectNumber();
                if (aliveObjectNumbers.contains(objectNumber)) {
                    return object;
                }
                aliveObjectNumbers.add(objectNumber);
                return super.visit(object, data);
            }
        };
        file.getTrailer().accept(visitor, null);
        IndirectObjects indirectObjects = file.getIndirectObjects();
        int objectNumber = 0;
        int objectCount = indirectObjects.size();
        while (objectNumber < objectCount) {
            if (!aliveObjectNumbers.contains(objectNumber)) {
                indirectObjects.remove(objectNumber);
            }
            ++objectNumber;
        }
    }
}

