/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.Pages;
import org.pdfclown.files.File;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfObjectWrapper;
import org.pdfclown.objects.PdfReference;
import org.pdfclown.objects.PdfStream;

public final class PageManager {
    private Document document;
    private Pages pages;

    public static long getSize(Page page) {
        return PageManager.getSize(page, new HashSet<PdfReference>());
    }

    public static long getSize(Page page, Set<PdfReference> visitedReferences) {
        return PageManager.getSize(page.getBaseObject(), visitedReferences, true);
    }

    private static long getSize(PdfDirectObject object, Set<PdfReference> visitedReferences, boolean isRoot) {
        long dataSize = 0L;
        PdfDataObject dataObject = PdfObject.resolve(object);
        if (object instanceof PdfReference) {
            PdfReference reference = (PdfReference)object;
            if (visitedReferences.contains(reference)) {
                return 0L;
            }
            if (dataObject instanceof PdfDictionary && PdfName.Page.equals(((PdfDictionary)dataObject).get(PdfName.Type)) && !isRoot) {
                return 0L;
            }
            visitedReferences.add(reference);
            Buffer buffer = new Buffer();
            reference.getIndirectObject().writeTo(buffer, reference.getFile());
            dataSize += buffer.getLength();
        }
        PdfArray values = null;
        if (dataObject instanceof PdfStream) {
            dataObject = ((PdfStream)dataObject).getHeader();
        }
        if (dataObject instanceof PdfDictionary) {
            values = ((PdfDictionary)dataObject).values();
        } else if (dataObject instanceof PdfArray) {
            values = (PdfArray)dataObject;
        }
        if (values != null) {
            for (PdfDirectObject value : values) {
                dataSize += PageManager.getSize(value, visitedReferences, false);
            }
        }
        return dataSize;
    }

    public PageManager() {
        this(null);
    }

    public PageManager(Document document) {
        this.setDocument(document);
    }

    public void add(Document document) {
        this.add(document.getPages());
    }

    public void add(int index, Document document) {
        this.add(index, document.getPages());
    }

    public void add(Collection<Page> pages) {
        Collection<? extends PdfObjectWrapper<?>> importedPages = this.document.include(pages);
        this.pages.addAll((Collection<? extends Page>)importedPages);
    }

    public void add(int index, Collection<Page> pages) {
        Collection<? extends PdfObjectWrapper<?>> importedPages = this.document.include(pages);
        if (index >= this.pages.size()) {
            this.pages.addAll((Collection<? extends Page>)importedPages);
        } else {
            this.pages.addAll(index, (Collection<? extends Page>)importedPages);
        }
    }

    public Document extract(int startIndex, int endIndex) {
        Document extractedDocument = new File().getDocument();
        extractedDocument.getPages().addAll((Collection<? extends Page>)extractedDocument.include(this.pages.subList(startIndex, endIndex)));
        return extractedDocument;
    }

    public void move(int startIndex, int endIndex, int targetIndex) {
        int pageCount = this.pages.size();
        List<Page> movingPages = this.pages.subList(startIndex, endIndex);
        this.pages.removeAll(movingPages);
        pageCount -= movingPages.size();
        if (targetIndex > startIndex) {
            targetIndex -= movingPages.size();
        }
        if (targetIndex >= pageCount) {
            this.pages.addAll((Collection<? extends Page>)movingPages);
        } else {
            this.pages.addAll(targetIndex, (Collection<? extends Page>)movingPages);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void remove(int startIndex, int endIndex) {
        List<Page> removingPages = this.pages.subList(startIndex, endIndex);
        this.pages.removeAll(removingPages);
        this.document.exclude(removingPages);
    }

    public void setDocument(Document value) {
        this.document = value;
        this.pages = this.document.getPages();
    }

    public List<Document> split() {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (Page page : this.pages) {
            Document pageDocument = new File().getDocument();
            pageDocument.getPages().add(page.clone(pageDocument));
            documents.add(pageDocument);
        }
        return documents;
    }

    public List<Document> split(int ... indexes) {
        ArrayList<Document> documents = new ArrayList<Document>();
        int startIndex = 0;
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            documents.add(this.extract(startIndex, index));
            startIndex = index;
            ++n2;
        }
        documents.add(this.extract(startIndex, this.pages.size()));
        return documents;
    }

    public List<Document> split(long maxDataSize) {
        ArrayList<Document> documents = new ArrayList<Document>();
        int startPageIndex = 0;
        long incrementalDataSize = 0L;
        HashSet<PdfReference> visitedReferences = new HashSet<PdfReference>();
        for (Page page : this.pages) {
            long pageDifferentialDataSize = PageManager.getSize(page, visitedReferences);
            if ((incrementalDataSize += pageDifferentialDataSize) <= maxDataSize) continue;
            int endPageIndex = page.getIndex();
            documents.add(this.extract(startPageIndex, endPageIndex));
            startPageIndex = endPageIndex;
            visitedReferences = new HashSet<PdfReference>();
            incrementalDataSize = PageManager.getSize(page, visitedReferences);
        }
        documents.add(this.extract(startPageIndex, this.pages.size()));
        return documents;
    }
}

