/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tools;

import org.pdfclown.documents.Page;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.Contents;
import org.pdfclown.documents.contents.composition.PrimitiveComposer;
import org.pdfclown.documents.contents.objects.RestoreGraphicsState;
import org.pdfclown.documents.contents.objects.SaveGraphicsState;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObject;
import org.pdfclown.objects.PdfStream;

public final class PageStamper {
    private Page page;
    private PrimitiveComposer background;
    private PrimitiveComposer foreground;

    public PageStamper() {
        this(null);
    }

    public PageStamper(Page page) {
        this.setPage(page);
    }

    public void flush() {
        PdfArray streams;
        PdfDirectObject contentsObject = ((PdfDictionary)this.page.getBaseDataObject()).get(PdfName.Contents);
        PdfDataObject contentsDataObject = PdfObject.resolve(contentsObject);
        if (contentsDataObject instanceof PdfStream) {
            streams = new PdfArray();
            streams.add(contentsObject);
            ((PdfDictionary)this.page.getBaseDataObject()).put(PdfName.Contents, streams);
        } else {
            streams = (PdfArray)contentsDataObject;
        }
        this.background.flush();
        streams.add(0, this.background.getScanner().getContents().getBaseObject());
        this.foreground.flush();
        streams.add(this.foreground.getScanner().getContents().getBaseObject());
    }

    public PrimitiveComposer getBackground() {
        return this.background;
    }

    public PrimitiveComposer getForeground() {
        return this.foreground;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page value) {
        this.page = value;
        if (this.page == null) {
            this.background = null;
            this.foreground = null;
        } else {
            this.background = this.createFilter();
            this.background.add(SaveGraphicsState.Value);
            this.background.add(RestoreGraphicsState.Value);
            this.background.add(SaveGraphicsState.Value);
            this.background.getScanner().move(1);
            this.foreground = this.createFilter();
            this.foreground.add(RestoreGraphicsState.Value);
        }
    }

    private PrimitiveComposer createFilter() {
        return new PrimitiveComposer(new ContentScanner(Contents.wrap(this.page.getFile().register(new PdfStream()), this.page)));
    }
}

