/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.tools;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pdfclown.documents.contents.ContentScanner;
import org.pdfclown.documents.contents.Contents;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.ITextString;
import org.pdfclown.documents.contents.TextChar;
import org.pdfclown.documents.contents.TextStyle;
import org.pdfclown.documents.contents.objects.ContainerObject;
import org.pdfclown.documents.contents.objects.Text;
import org.pdfclown.documents.contents.objects.XObject;
import org.pdfclown.util.math.Interval;

public final class TextExtractor {
    private AreaModeEnum areaMode = AreaModeEnum.Containment;
    private List<Rectangle2D> areas;
    private double areaTolerance = 0.0;
    private boolean dehyphenated;
    private boolean sorted;

    public static String toString(Map<Rectangle2D, List<ITextString>> textStrings) {
        return TextExtractor.toString(textStrings, "", "");
    }

    public static String toString(Map<Rectangle2D, List<ITextString>> textStrings, String lineSeparator, String areaSeparator) {
        StringBuilder textBuilder = new StringBuilder();
        for (List<ITextString> areaTextStrings : textStrings.values()) {
            if (textBuilder.length() > 0) {
                textBuilder.append(areaSeparator);
            }
            for (ITextString textString : areaTextStrings) {
                textBuilder.append(textString.getText()).append(lineSeparator);
            }
        }
        return textBuilder.toString();
    }

    public TextExtractor() {
        this(true, false);
    }

    public TextExtractor(boolean sorted, boolean dehyphenated) {
        this(null, sorted, dehyphenated);
    }

    public TextExtractor(List<Rectangle2D> areas, boolean sorted, boolean dehyphenated) {
        this.setAreas(areas);
        this.setDehyphenated(dehyphenated);
        this.setSorted(sorted);
    }

    public Map<Rectangle2D, List<ITextString>> extract(IContentContext contentContext) {
        Map<Rectangle2D, List<ITextString>> extractedTextStrings;
        ArrayList<ITextString> textStrings = new ArrayList<ITextString>();
        ArrayList<ContentScanner.TextStringWrapper> rawTextStrings = new ArrayList<ContentScanner.TextStringWrapper>();
        this.extract(new ContentScanner(contentContext), rawTextStrings);
        if (this.sorted) {
            this.sort(rawTextStrings, textStrings);
        } else {
            textStrings.addAll(rawTextStrings);
        }
        if (this.areas.isEmpty()) {
            extractedTextStrings = new HashMap<Rectangle2D, List<ITextString>>();
            extractedTextStrings.put(null, textStrings);
        } else {
            extractedTextStrings = this.filter(textStrings, this.areas.toArray(new Rectangle2D[this.areas.size()]));
        }
        return extractedTextStrings;
    }

    public Map<Rectangle2D, List<ITextString>> extract(Contents contents) {
        return this.extract(contents.getContentContext());
    }

    public List<ITextString> filter(Map<Rectangle2D, List<ITextString>> textStrings, final List<Interval<Integer>> intervals) {
        final ArrayList<ITextString> filteredTextStrings = new ArrayList<ITextString>();
        this.filter(textStrings, new IIntervalFilter(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < intervals.size();
            }

            @Override
            public Interval<Integer> next() {
                return (Interval)intervals.get(this.index++);
            }

            @Override
            public void process(Interval<Integer> interval, ITextString match) {
                filteredTextStrings.add(match);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
        return filteredTextStrings;
    }

    public void filter(Map<Rectangle2D, List<ITextString>> textStrings, IIntervalFilter filter) {
        Iterator<List<ITextString>> textStringsIterator = textStrings.values().iterator();
        if (!textStringsIterator.hasNext()) {
            return;
        }
        Iterator<ITextString> areaTextStringsIterator = textStringsIterator.next().iterator();
        if (!areaTextStringsIterator.hasNext()) {
            return;
        }
        List<TextChar> textChars = areaTextStringsIterator.next().getTextChars();
        int baseTextCharIndex = 0;
        int textCharIndex = 0;
        while (filter.hasNext()) {
            Interval interval = (Interval)filter.next();
            TextString match = new TextString();
            int matchStartIndex = (Integer)interval.getLow();
            int matchEndIndex = (Integer)interval.getHigh();
            while (matchStartIndex > baseTextCharIndex + textChars.size()) {
                baseTextCharIndex += textChars.size();
                if (!areaTextStringsIterator.hasNext()) {
                    areaTextStringsIterator = textStringsIterator.next().iterator();
                }
                textChars = areaTextStringsIterator.next().getTextChars();
            }
            textCharIndex = matchStartIndex - baseTextCharIndex;
            while (baseTextCharIndex + textCharIndex < matchEndIndex) {
                if (textCharIndex == textChars.size()) {
                    baseTextCharIndex += textChars.size();
                    if (!areaTextStringsIterator.hasNext()) {
                        areaTextStringsIterator = textStringsIterator.next().iterator();
                    }
                    textChars = areaTextStringsIterator.next().getTextChars();
                    textCharIndex = 0;
                }
                match.textChars.add(textChars.get(textCharIndex++));
            }
            filter.process(interval, match);
        }
    }

    public List<ITextString> filter(Map<Rectangle2D, List<ITextString>> textStrings, Rectangle2D area) {
        return this.filter(textStrings, new Rectangle2D[]{area}).get(area);
    }

    public Map<Rectangle2D, List<ITextString>> filter(Map<Rectangle2D, List<ITextString>> textStrings, Rectangle2D ... areas) {
        Map<Rectangle2D, List<ITextString>> filteredTextStrings = null;
        for (List<ITextString> areaTextStrings : textStrings.values()) {
            Map<Rectangle2D, List<ITextString>> filteredAreasTextStrings = this.filter(areaTextStrings, areas);
            if (filteredTextStrings == null) {
                filteredTextStrings = filteredAreasTextStrings;
                continue;
            }
            for (Map.Entry<Rectangle2D, List<ITextString>> filteredAreaTextStringsEntry : filteredAreasTextStrings.entrySet()) {
                filteredTextStrings.get(filteredAreaTextStringsEntry.getKey()).addAll((Collection<ITextString>)filteredAreaTextStringsEntry.getValue());
            }
        }
        return filteredTextStrings;
    }

    public List<ITextString> filter(List<? extends ITextString> textStrings, Rectangle2D area) {
        return this.filter(textStrings, new Rectangle2D[]{area}).get(area);
    }

    public Map<Rectangle2D, List<ITextString>> filter(List<? extends ITextString> textStrings, Rectangle2D ... areas) {
        HashMap<Rectangle2D, List<ITextString>> filteredAreasTextStrings = new HashMap<Rectangle2D, List<ITextString>>();
        Rectangle2D[] rectangle2DArray = areas;
        int n = areas.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle2D area = rectangle2DArray[n2];
            ArrayList<TextString> filteredAreaTextStrings = new ArrayList<TextString>();
            filteredAreasTextStrings.put(area, filteredAreaTextStrings);
            Rectangle2D toleratedArea = this.areaTolerance != 0.0 ? new Rectangle2D.Double(area.getX() - this.areaTolerance, area.getY() - this.areaTolerance, area.getWidth() + this.areaTolerance * 2.0, area.getHeight() + this.areaTolerance * 2.0) : area;
            for (ITextString iTextString : textStrings) {
                Rectangle2D textStringBox = iTextString.getBox();
                if (!toleratedArea.intersects(textStringBox)) continue;
                TextString filteredTextString = new TextString();
                List<TextChar> filteredTextStringChars = filteredTextString.getTextChars();
                for (TextChar textChar : iTextString.getTextChars()) {
                    Rectangle2D textCharBox = textChar.getBox();
                    if ((this.areaMode != AreaModeEnum.Containment || !toleratedArea.contains(textCharBox)) && (this.areaMode != AreaModeEnum.Intersection || !toleratedArea.intersects(textCharBox))) continue;
                    filteredTextStringChars.add(textChar);
                }
                filteredAreaTextStrings.add(filteredTextString);
            }
            ++n2;
        }
        return filteredAreasTextStrings;
    }

    public AreaModeEnum getAreaMode() {
        return this.areaMode;
    }

    public List<Rectangle2D> getAreas() {
        return this.areas;
    }

    public double getAreaTolerance() {
        return this.areaTolerance;
    }

    public boolean isDehyphenated() {
        return this.dehyphenated;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setAreaMode(AreaModeEnum value) {
        this.areaMode = value;
    }

    public void setAreas(List<Rectangle2D> value) {
        this.areas = value == null ? new ArrayList() : value;
    }

    public void setAreaTolerance(double value) {
        this.areaTolerance = value;
    }

    public void setDehyphenated(boolean value) {
        this.dehyphenated = value;
        if (this.dehyphenated) {
            this.setSorted(true);
        }
    }

    public void setSorted(boolean value) {
        this.sorted = value;
        if (!this.sorted) {
            this.setDehyphenated(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void extract(ContentScanner level, List<ContentScanner.TextStringWrapper> extractedTextStrings) {
        if (level != null) ** GOTO lbl13
        return;
lbl-1000:
        // 1 sources

        {
            content = level.getCurrent();
            if (content instanceof Text) {
                extractedTextStrings.addAll(((ContentScanner.TextWrapper)level.getCurrentWrapper()).getTextStrings());
                continue;
            }
            if (content instanceof XObject) {
                this.extract(((XObject)content).getScanner(level), extractedTextStrings);
                continue;
            }
            if (!(content instanceof ContainerObject)) continue;
            this.extract(level.getChildLevel(), extractedTextStrings);
lbl13:
            // 5 sources

            ** while (level.moveNext())
        }
lbl14:
        // 1 sources

    }

    private void sort(List<ContentScanner.TextStringWrapper> rawTextStrings, List<ITextString> textStrings) {
        TextStringPositionComparator positionComparator = new TextStringPositionComparator();
        Collections.sort(rawTextStrings, positionComparator);
        TextString textString = null;
        TextStyle textStyle = null;
        TextChar previousTextChar = null;
        boolean dehyphenating = false;
        for (ContentScanner.TextStringWrapper rawTextString : rawTextStrings) {
            double spaceWidth;
            if (textString != null && !textString.textChars.isEmpty() && !TextStringPositionComparator.isOnTheSameLine(textString.getBox(), rawTextString.getBox())) {
                if (this.dehyphenated && previousTextChar.getValue() == '-') {
                    textString.textChars.remove(previousTextChar);
                    dehyphenating = true;
                } else {
                    textString.textChars.add(new TextChar(' ', new Rectangle2D.Double(previousTextChar.getBox().getMaxX(), previousTextChar.getBox().getY(), 0.0, previousTextChar.getBox().getHeight()), textStyle, true));
                    textString = null;
                    dehyphenating = false;
                }
                previousTextChar = null;
            }
            if (textString == null) {
                textString = new TextString();
                textStrings.add(textString);
            }
            if ((spaceWidth = (textStyle = rawTextString.getStyle()).getFont().getWidth(' ', textStyle.getFontSize())) == 0.0) {
                spaceWidth = textStyle.getFontSize() * 0.25;
            }
            for (TextChar textChar : rawTextString.getTextChars()) {
                if (previousTextChar != null) {
                    double characterSpace = textChar.getBox().getX() - previousTextChar.getBox().getMaxX();
                    if (characterSpace >= spaceWidth) {
                        previousTextChar = new TextChar(' ', new Rectangle2D.Double(previousTextChar.getBox().getMaxX(), textChar.getBox().getY(), characterSpace, textChar.getBox().getHeight()), textStyle, true);
                        textString.textChars.add(previousTextChar);
                    }
                    if (dehyphenating && previousTextChar.getValue() == ' ') {
                        textString = new TextString();
                        textStrings.add(textString);
                        dehyphenating = false;
                    }
                }
                previousTextChar = textChar;
                textString.textChars.add(previousTextChar);
            }
        }
    }

    public static enum AreaModeEnum {
        Containment,
        Intersection;

    }

    public static interface IIntervalFilter
    extends Iterator<Interval<Integer>> {
        public void process(Interval<Integer> var1, ITextString var2);
    }

    private static class TextString
    implements ITextString {
        private final List<TextChar> textChars = new ArrayList<TextChar>();

        private TextString() {
        }

        @Override
        public Rectangle2D getBox() {
            Rectangle2D box = null;
            for (TextChar textChar : this.textChars) {
                if (box == null) {
                    box = (Rectangle2D)textChar.getBox().clone();
                    continue;
                }
                box.add(textChar.getBox());
            }
            return box;
        }

        @Override
        public String getText() {
            StringBuilder textBuilder = new StringBuilder();
            for (TextChar textChar : this.textChars) {
                textBuilder.append(textChar);
            }
            return textBuilder.toString();
        }

        @Override
        public List<TextChar> getTextChars() {
            return this.textChars;
        }
    }

    private static class TextStringPositionComparator
    implements Comparator<ITextString> {
        private TextStringPositionComparator() {
        }

        public static boolean isOnTheSameLine(Rectangle2D box1, Rectangle2D box2) {
            double minHeight = Math.min(box1.getHeight(), box2.getHeight());
            double yThreshold = minHeight * 0.75;
            return box1.getY() > box2.getY() - yThreshold && box1.getY() < box2.getMaxY() + yThreshold - minHeight || box2.getY() > box1.getY() - yThreshold && box2.getY() < box1.getMaxY() + yThreshold - minHeight;
        }

        @Override
        public int compare(ITextString textString1, ITextString textString2) {
            Rectangle2D box2;
            Rectangle2D box1 = textString1.getBox();
            if (TextStringPositionComparator.isOnTheSameLine(box1, box2 = textString2.getBox())) {
                if (box1.getX() < box2.getX()) {
                    return -1;
                }
                if (box1.getX() > box2.getX()) {
                    return 1;
                }
                return 0;
            }
            if (box1.getY() < box2.getY()) {
                return -1;
            }
            return 1;
        }
    }
}

