/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.util.math;

import org.pdfclown.util.math.SquareMatrix;

public final class LUDecomposition {
    private double[][] data;
    private int size;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(SquareMatrix matrix) {
        this.data = ((SquareMatrix)matrix.clone()).getData();
        this.size = matrix.getSize();
        this.piv = new int[this.size];
        int i = 0;
        while (i < this.size) {
            this.piv[i] = i;
            ++i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.size];
        int j = 0;
        while (j < this.size) {
            int i2 = 0;
            while (i2 < this.size) {
                LUcolj[i2] = this.data[i2][j];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.size) {
                double[] LUrowi = this.data[i2];
                int kmax = Math.min(i2, j);
                double s = 0.0;
                int k = 0;
                while (k < kmax) {
                    s += LUrowi[k] * LUcolj[k];
                    ++k;
                }
                int n = i2++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            int i3 = j + 1;
            while (i3 < this.size) {
                if (Math.abs(LUcolj[i3]) > Math.abs(LUcolj[p])) {
                    p = i3;
                }
                ++i3;
            }
            if (p != j) {
                int k = 0;
                while (k < this.size) {
                    double t = this.data[p][k];
                    this.data[p][k] = this.data[j][k];
                    this.data[j][k] = t;
                    ++k;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (j < this.size & this.data[j][j] != 0.0) {
                i3 = j + 1;
                while (i3 < this.size) {
                    double[] dArray = this.data[i3];
                    int n = j;
                    dArray[n] = dArray[n] / this.data[j][j];
                    ++i3;
                }
            }
            ++j;
        }
    }

    public double getDet() {
        double d = this.pivsign;
        int j = 0;
        while (j < this.size) {
            d *= this.data[j][j];
            ++j;
        }
        return d;
    }

    public SquareMatrix getL() {
        SquareMatrix X = new SquareMatrix(this.size);
        double[][] L = X.getData();
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                L[i][j] = i > j ? this.data[i][j] : (i == j ? 1.0 : 0.0);
                ++j;
            }
            ++i;
        }
        return X;
    }

    public SquareMatrix getU() {
        SquareMatrix X = new SquareMatrix(this.size);
        double[][] U = X.getData();
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                U[i][j] = i <= j ? this.data[i][j] : 0.0;
                ++j;
            }
            ++i;
        }
        return X;
    }

    public int[] getPivot() {
        int[] pivot = new int[this.size];
        int i = 0;
        while (i < this.size) {
            pivot[i] = this.piv[i];
            ++i;
        }
        return pivot;
    }

    public boolean isNonsingular() {
        int j = 0;
        while (j < this.size) {
            if (this.data[j][j] == 0.0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public SquareMatrix solve(SquareMatrix target) {
        int j;
        int i;
        if (target.getSize() != this.size) {
            throw new IllegalArgumentException("Matrix size must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        SquareMatrix Xmat = target.getMatrix(this.piv, 0);
        double[][] X = Xmat.getData();
        int k = 0;
        while (k < this.size) {
            i = k + 1;
            while (i < this.size) {
                j = 0;
                while (j < this.size) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.data[i][k];
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = this.size - 1;
        while (k >= 0) {
            int j2 = 0;
            while (j2 < this.size) {
                double[] dArray = X[k];
                int n = j2++;
                dArray[n] = dArray[n] / this.data[k][k];
            }
            i = 0;
            while (i < k) {
                j = 0;
                while (j < this.size) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.data[i][k];
                    ++j;
                }
                ++i;
            }
            --k;
        }
        return Xmat;
    }
}

