/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.util.parsers;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import org.pdfclown.bytes.Buffer;
import org.pdfclown.bytes.IInputStream;
import org.pdfclown.util.parsers.ParseException;

public class PostScriptParser
implements Closeable {
    private IInputStream stream;
    private Object token;
    private TokenTypeEnum tokenType;

    protected static int getHex(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        return -1;
    }

    protected static boolean isDelimiter(int c) {
        return c == 40 || c == 41 || c == 60 || c == 62 || c == 91 || c == 93 || c == 47 || c == 37;
    }

    protected static boolean isEOL(int c) {
        return c == 10 || c == 13;
    }

    protected static boolean isWhitespace(int c) {
        return c == 32 || PostScriptParser.isEOL(c) || c == 0 || c == 9 || c == 12;
    }

    public PostScriptParser(IInputStream stream) {
        this.stream = stream;
    }

    public PostScriptParser(byte[] data) {
        this.stream = new Buffer(data);
    }

    public long getLength() {
        return this.stream.getLength();
    }

    public long getPosition() {
        return this.stream.getPosition();
    }

    public IInputStream getStream() {
        return this.stream;
    }

    public Object getToken() {
        return this.token;
    }

    public Object getToken(int offset) {
        this.moveNext(offset);
        return this.getToken();
    }

    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public int hashCode() {
        return this.stream.hashCode();
    }

    public boolean moveNext(int offset) {
        int index = 0;
        while (index < offset) {
            if (!this.moveNext()) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean moveNext() {
        StringBuilder buffer = null;
        this.token = null;
        int c = 0;
        try {
            while (PostScriptParser.isWhitespace(c = this.stream.readUnsignedByte())) {
            }
        }
        catch (EOFException e) {
            return false;
        }
        block9 : switch (c) {
            case 47: {
                this.tokenType = TokenTypeEnum.Name;
                buffer = new StringBuilder();
                try {
                    while (!PostScriptParser.isDelimiter(c = this.stream.readUnsignedByte()) && !PostScriptParser.isWhitespace(c)) {
                        buffer.append((char)c);
                    }
                    this.stream.skip(-1L);
                }
                catch (EOFException e) {}
                break;
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.tokenType = c == 46 ? TokenTypeEnum.Real : TokenTypeEnum.Integer;
                buffer = new StringBuilder();
                try {
                    while (true) {
                        buffer.append((char)c);
                        c = this.stream.readUnsignedByte();
                        if (c == 46) {
                            this.tokenType = TokenTypeEnum.Real;
                            continue;
                        }
                        if (c < 48 || c > 57) break;
                    }
                    this.stream.skip(-1L);
                }
                catch (EOFException e) {}
                break;
            }
            case 91: {
                this.tokenType = TokenTypeEnum.ArrayBegin;
                break;
            }
            case 93: {
                this.tokenType = TokenTypeEnum.ArrayEnd;
                break;
            }
            case 60: {
                try {
                    c = this.stream.readUnsignedByte();
                }
                catch (EOFException e) {
                    throw new ParseException("Unexpected EOF (isolated opening angle-bracket character).", e);
                }
                if (c == 60) {
                    this.tokenType = TokenTypeEnum.DictionaryBegin;
                    break;
                }
                this.tokenType = TokenTypeEnum.Hex;
                buffer = new StringBuilder();
                try {
                    while (c != 62) {
                        if (!PostScriptParser.isWhitespace(c)) {
                            buffer.append((char)c);
                        }
                        c = this.stream.readUnsignedByte();
                    }
                    break;
                }
                catch (EOFException e) {
                    throw new ParseException("Unexpected EOF (malformed hex string).", e);
                }
            }
            case 62: {
                try {
                    c = this.stream.readUnsignedByte();
                }
                catch (EOFException e) {
                    throw new ParseException("Unexpected EOF (malformed dictionary).", e);
                }
                if (c != 62) {
                    throw new ParseException("Malformed dictionary.", this.stream.getPosition());
                }
                this.tokenType = TokenTypeEnum.DictionaryEnd;
                break;
            }
            case 40: {
                this.tokenType = TokenTypeEnum.Literal;
                buffer = new StringBuilder();
                int level = 0;
                try {
                    while (true) {
                        if ((c = this.stream.readUnsignedByte()) == 40) {
                            ++level;
                        } else if (c == 41) {
                            --level;
                        } else if (c == 92) {
                            boolean lineBreak = false;
                            c = this.stream.readUnsignedByte();
                            switch (c) {
                                case 110: {
                                    c = 10;
                                    break;
                                }
                                case 114: {
                                    c = 13;
                                    break;
                                }
                                case 116: {
                                    c = 9;
                                    break;
                                }
                                case 98: {
                                    c = 8;
                                    break;
                                }
                                case 102: {
                                    c = 12;
                                    break;
                                }
                                case 40: 
                                case 41: 
                                case 92: {
                                    break;
                                }
                                case 13: {
                                    lineBreak = true;
                                    c = this.stream.readUnsignedByte();
                                    if (c == 10) break;
                                    this.stream.skip(-1L);
                                    break;
                                }
                                case 10: {
                                    lineBreak = true;
                                    break;
                                }
                                default: {
                                    if (c < 48 || c > 55) break;
                                    int octal = c - 48;
                                    c = this.stream.readUnsignedByte();
                                    if (c < 48 || c > 55) {
                                        c = octal;
                                        this.stream.skip(-1L);
                                        break;
                                    }
                                    octal = (octal << 3) + c - 48;
                                    c = this.stream.readUnsignedByte();
                                    if (c < 48 || c > 55) {
                                        c = octal;
                                        this.stream.skip(-1L);
                                        break;
                                    }
                                    octal = (octal << 3) + c - 48;
                                    c = octal & 0xFF;
                                }
                            }
                            if (lineBreak) {
                                continue;
                            }
                        } else if (c == 13 && (c = this.stream.readUnsignedByte()) != 10) {
                            c = 10;
                            this.stream.skip(-1L);
                        }
                        if (level == -1) break block9;
                        buffer.append((char)c);
                    }
                }
                catch (EOFException e) {
                    throw new ParseException("Unexpected EOF (malformed literal string).", e);
                }
            }
            case 37: {
                this.tokenType = TokenTypeEnum.Comment;
                buffer = new StringBuilder();
                try {
                    while (!PostScriptParser.isEOL(c = this.stream.readUnsignedByte())) {
                        buffer.append((char)c);
                    }
                    break;
                }
                catch (EOFException eOFException) {
                    break;
                }
            }
            default: {
                this.tokenType = TokenTypeEnum.Keyword;
                buffer = new StringBuilder();
                try {
                    do {
                        buffer.append((char)c);
                    } while (!PostScriptParser.isDelimiter(c = this.stream.readUnsignedByte()) && !PostScriptParser.isWhitespace(c));
                    this.stream.skip(-1L);
                    break;
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
        }
        if (buffer != null) {
            switch (this.tokenType) {
                case Keyword: {
                    this.token = buffer.toString();
                    if (this.token.equals("false") || this.token.equals("true")) {
                        this.token = Boolean.parseBoolean((String)this.token);
                        this.tokenType = TokenTypeEnum.Boolean;
                        break;
                    }
                    if (!this.token.equals("null")) break;
                    this.token = null;
                    this.tokenType = TokenTypeEnum.Null;
                    break;
                }
                case Literal: 
                case Hex: 
                case Name: 
                case Comment: {
                    this.token = buffer.toString();
                    break;
                }
                case Integer: {
                    this.token = Integer.parseInt(buffer.toString());
                    break;
                }
                case Real: {
                    this.token = Double.parseDouble(buffer.toString());
                }
            }
        }
        return true;
    }

    public void seek(long position) {
        this.stream.seek(position);
    }

    public void skip(long offset) {
        this.stream.skip(offset);
    }

    public boolean skipEOL() {
        try {
            int c;
            while (PostScriptParser.isEOL(c = this.stream.readUnsignedByte())) {
            }
        }
        catch (EOFException e) {
            return false;
        }
        this.stream.skip(-1L);
        return true;
    }

    public boolean skipWhitespace() {
        try {
            int c;
            while (PostScriptParser.isWhitespace(c = this.stream.readUnsignedByte())) {
            }
        }
        catch (EOFException e) {
            return false;
        }
        this.stream.skip(-1L);
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    protected void setToken(Object value) {
        this.token = value;
    }

    protected void setTokenType(TokenTypeEnum value) {
        this.tokenType = value;
    }

    public static enum TokenTypeEnum {
        Keyword,
        Boolean,
        Integer,
        Real,
        Literal,
        Hex,
        Name,
        Comment,
        ArrayBegin,
        ArrayEnd,
        DictionaryBegin,
        DictionaryEnd,
        Null;

    }
}

